/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.transaction;

import com.backendless.transaction.OpResult;
import java.util.Map;

public class OpResultValueReference {
    private final OpResult opResult;
    private final Integer resultIndex;
    private final String propName;

    OpResultValueReference(OpResult opResult, Integer resultIndex, String propName) {
        this.opResult = opResult;
        this.resultIndex = resultIndex;
        this.propName = propName;
    }

    OpResultValueReference(OpResult opResult, Integer resultIndex) {
        this.opResult = opResult;
        this.resultIndex = resultIndex;
        this.propName = null;
    }

    OpResultValueReference(OpResult opResult, String propName) {
        this.opResult = opResult;
        this.resultIndex = null;
        this.propName = propName;
    }

    public OpResult getOpResult() {
        return this.opResult;
    }

    public Integer getResultIndex() {
        return this.resultIndex;
    }

    public String getPropName() {
        return this.propName;
    }

    public OpResultValueReference resolveTo(String propName) {
        return new OpResultValueReference(this.opResult, this.resultIndex, propName);
    }

    Map<String, Object> makeReference() {
        Map<String, Object> referenceMap = this.opResult.makeReference();
        if (this.resultIndex != null) {
            referenceMap.put("resultIndex", this.resultIndex);
        }
        if (this.propName != null) {
            referenceMap.put("propName", this.propName);
        }
        return referenceMap;
    }
}

