/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.transaction;

import com.backendless.Persistence;
import com.backendless.persistence.BackendlessSerializer;
import com.backendless.transaction.OpResult;
import com.backendless.transaction.OpResultIdGenerator;
import com.backendless.transaction.OpResultValueReference;
import com.backendless.transaction.Operation;
import com.backendless.transaction.OperationAddRelation;
import com.backendless.transaction.OperationDeleteRelation;
import com.backendless.transaction.OperationSetRelation;
import com.backendless.transaction.OperationType;
import com.backendless.transaction.RelationOperation;
import com.backendless.transaction.TransactionHelper;
import com.backendless.transaction.payload.Relation;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class RelationOperationImpl
implements RelationOperation {
    private final List<Operation> operations;
    private final OpResultIdGenerator opResultIdGenerator;

    public RelationOperationImpl(List<Operation> operations, OpResultIdGenerator opResultIdGenerator) {
        this.operations = operations;
        this.opResultIdGenerator = opResultIdGenerator;
    }

    @Override
    public OpResult addOperation(OperationType operationType, String parentTable, Map<String, Object> parentObject, String columnName, String[] childrenObjectIds) {
        String parentObjectId = TransactionHelper.convertObjectMapToObjectId(parentObject);
        if (childrenObjectIds == null || childrenObjectIds.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, null, childrenObjectIds);
    }

    @Override
    public <E> OpResult addOperation(OperationType operationType, String parentTable, Map<String, Object> parentObject, String columnName, E[] childrenInstances) {
        if (childrenInstances == null || childrenInstances.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        if (childrenInstances[0] instanceof String) {
            String[] childrenObjectIds = (String[])childrenInstances;
            return this.addOperation(operationType, parentTable, parentObject, columnName, childrenObjectIds);
        }
        String parentObjectId = TransactionHelper.convertObjectMapToObjectId(parentObject);
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, childrenInstances);
    }

    @Override
    public OpResult addOperation(OperationType operationType, String parentTable, Map<String, Object> parentObject, String columnName, List<Map<String, Object>> childrenMaps) {
        String parentObjectId = TransactionHelper.convertObjectMapToObjectId(parentObject);
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, childrenMaps);
    }

    @Override
    public OpResult addOperation(OperationType operationType, String parentTable, Map<String, Object> parentObject, String columnName, OpResult children) {
        String parentObjectId = TransactionHelper.convertObjectMapToObjectId(parentObject);
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, children);
    }

    @Override
    public OpResult addOperation(OperationType operationType, String parentTable, Map<String, Object> parentObject, String columnName, String whereClauseForChildren) {
        String parentObjectId = TransactionHelper.convertObjectMapToObjectId(parentObject);
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, whereClauseForChildren);
    }

    @Override
    public OpResult addOperation(OperationType operationType, String parentTable, String parentObjectId, String columnName, String[] childrenObjectIds) {
        if (childrenObjectIds == null || childrenObjectIds.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, null, childrenObjectIds);
    }

    @Override
    public <E> OpResult addOperation(OperationType operationType, String parentTable, String parentObjectId, String columnName, E[] childrenInstances) {
        if (childrenInstances == null || childrenInstances.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        if (childrenInstances[0] instanceof String) {
            String[] childrenObjectIds = (String[])childrenInstances;
            return this.addOperation(operationType, parentTable, parentObjectId, columnName, childrenObjectIds);
        }
        List<String> childrenIds = this.getChildrenFromArrayInstances(childrenInstances);
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, null, childrenIds);
    }

    @Override
    public OpResult addOperation(OperationType operationType, String parentTable, String parentObjectId, String columnName, List<Map<String, Object>> childrenMaps) {
        List<Object> childrenIds = this.getChildrenFromListMap(childrenMaps);
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, null, childrenIds);
    }

    @Override
    public OpResult addOperation(OperationType operationType, String parentTable, String parentObjectId, String columnName, OpResult children) {
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, null, this.makeChildren(children));
    }

    @Override
    public OpResult addOperation(OperationType operationType, String parentTable, String parentObjectId, String columnName, String whereClauseForChildren) {
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, whereClauseForChildren, null);
    }

    @Override
    public <E> OpResult addOperation(OperationType operationType, E parentObject, String columnName, String[] childrenObjectIds) {
        String parentObjectId = this.getParentObjectIdFromInstance(parentObject);
        String parentTable = BackendlessSerializer.getSimpleName(parentObject.getClass());
        if (childrenObjectIds == null || childrenObjectIds.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, null, childrenObjectIds);
    }

    @Override
    public <E, U> OpResult addOperation(OperationType operationType, E parentObject, String columnName, U[] childrenInstances) {
        if (childrenInstances == null || childrenInstances.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        if (childrenInstances[0] instanceof String) {
            String[] childrenObjectIds = (String[])childrenInstances;
            return this.addOperation(operationType, parentObject, columnName, childrenObjectIds);
        }
        String parentObjectId = this.getParentObjectIdFromInstance(parentObject);
        String parentTable = BackendlessSerializer.getSimpleName(parentObject.getClass());
        List<String> childrenIds = this.getChildrenFromArrayInstances(childrenInstances);
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, null, childrenIds);
    }

    @Override
    public <E> OpResult addOperation(OperationType operationType, E parentObject, String columnName, List<Map<String, Object>> childrenMaps) {
        String parentObjectId = this.getParentObjectIdFromInstance(parentObject);
        String parentTable = BackendlessSerializer.getSimpleName(parentObject.getClass());
        List<Object> childrenIds = this.getChildrenFromListMap(childrenMaps);
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, null, childrenIds);
    }

    @Override
    public <E> OpResult addOperation(OperationType operationType, E parentObject, String columnName, OpResult children) {
        String parentObjectId = this.getParentObjectIdFromInstance(parentObject);
        String parentTable = BackendlessSerializer.getSimpleName(parentObject.getClass());
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, null, this.makeChildren(children));
    }

    @Override
    public <E> OpResult addOperation(OperationType operationType, E parentObject, String columnName, String whereClauseForChildren) {
        String parentObjectId = this.getParentObjectIdFromInstance(parentObject);
        String parentTable = BackendlessSerializer.getSimpleName(parentObject.getClass());
        return this.addOperation(operationType, parentTable, parentObjectId, columnName, whereClauseForChildren, null);
    }

    @Override
    public OpResult addOperation(OperationType operationType, OpResult parentObject, String columnName, String[] childrenObjectIds) {
        if (childrenObjectIds == null || childrenObjectIds.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        return this.addOperation(operationType, parentObject.getTableName(), parentObject.resolveTo("objectId").makeReference(), columnName, null, childrenObjectIds);
    }

    @Override
    public <E> OpResult addOperation(OperationType operationType, OpResult parentObject, String columnName, E[] childrenInstances) {
        if (childrenInstances == null || childrenInstances.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        if (childrenInstances[0] instanceof String) {
            String[] childrenObjectIds = (String[])childrenInstances;
            return this.addOperation(operationType, parentObject, columnName, childrenObjectIds);
        }
        this.checkOpResultFoParent(parentObject);
        List<String> childrenIds = this.getChildrenFromArrayInstances(childrenInstances);
        return this.addOperation(operationType, parentObject.getTableName(), parentObject.resolveTo("objectId").makeReference(), columnName, null, childrenIds);
    }

    @Override
    public OpResult addOperation(OperationType operationType, OpResult parentObject, String columnName, List<Map<String, Object>> childrenMaps) {
        this.checkOpResultFoParent(parentObject);
        List<Object> childrenIds = this.getChildrenFromListMap(childrenMaps);
        return this.addOperation(operationType, parentObject.getTableName(), parentObject.resolveTo("objectId").makeReference(), columnName, null, childrenIds);
    }

    @Override
    public OpResult addOperation(OperationType operationType, OpResult parentObject, String columnName, OpResult children) {
        this.checkOpResultFoParent(parentObject);
        return this.addOperation(operationType, parentObject.getTableName(), parentObject.resolveTo("objectId").makeReference(), columnName, null, this.makeChildren(children));
    }

    @Override
    public OpResult addOperation(OperationType operationType, OpResult parentObject, String columnName, String whereClauseForChildren) {
        this.checkOpResultFoParent(parentObject);
        return this.addOperation(operationType, parentObject.getTableName(), parentObject.resolveTo("objectId").makeReference(), columnName, whereClauseForChildren, null);
    }

    @Override
    public OpResult addOperation(OperationType operationType, OpResultValueReference parentObject, String columnName, String[] childrenObjectIds) {
        Map<String, Object> referenceToObjectId = this.getReferenceToParentFromOpResultValue(parentObject);
        if (childrenObjectIds == null || childrenObjectIds.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        return this.addOperation(operationType, parentObject.getOpResult().getTableName(), referenceToObjectId, columnName, null, childrenObjectIds);
    }

    @Override
    public <E> OpResult addOperation(OperationType operationType, OpResultValueReference parentObject, String columnName, E[] childrenInstances) {
        if (childrenInstances == null || childrenInstances.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        if (childrenInstances[0] instanceof String) {
            String[] childrenObjectIds = (String[])childrenInstances;
            return this.addOperation(operationType, parentObject, columnName, childrenObjectIds);
        }
        Map<String, Object> referenceToObjectId = this.getReferenceToParentFromOpResultValue(parentObject);
        List<String> childrenIds = this.getChildrenFromArrayInstances(childrenInstances);
        return this.addOperation(operationType, parentObject.getOpResult().getTableName(), referenceToObjectId, columnName, null, childrenIds);
    }

    @Override
    public OpResult addOperation(OperationType operationType, OpResultValueReference parentObject, String columnName, List<Map<String, Object>> childrenMaps) {
        Map<String, Object> referenceToObjectId = this.getReferenceToParentFromOpResultValue(parentObject);
        List<Object> childrenIds = this.getChildrenFromListMap(childrenMaps);
        return this.addOperation(operationType, parentObject.getOpResult().getTableName(), referenceToObjectId, columnName, null, childrenIds);
    }

    @Override
    public OpResult addOperation(OperationType operationType, OpResultValueReference parentObject, String columnName, OpResult children) {
        Map<String, Object> referenceToObjectId = this.getReferenceToParentFromOpResultValue(parentObject);
        return this.addOperation(operationType, parentObject.getOpResult().getTableName(), referenceToObjectId, columnName, null, this.makeChildren(children));
    }

    @Override
    public OpResult addOperation(OperationType operationType, OpResultValueReference parentObject, String columnName, String whereClauseForChildren) {
        Map<String, Object> referenceToObjectId = this.getReferenceToParentFromOpResultValue(parentObject);
        return this.addOperation(operationType, parentObject.getOpResult().getTableName(), referenceToObjectId, columnName, whereClauseForChildren, null);
    }

    private OpResult addOperation(OperationType operationType, String parentTable, Object parentObject, String columnName, String whereClauseForChildren, Object children) {
        if (parentTable == null || parentTable.equals("")) {
            throw new IllegalArgumentException("Parent table name can not be null or empty");
        }
        if (columnName == null || columnName.equals("")) {
            throw new IllegalArgumentException("Relation column name can not be null or empty");
        }
        String operationResultId = this.opResultIdGenerator.generateOpResultId(operationType, parentTable);
        Relation relation = new Relation();
        relation.setParentObject(parentObject);
        relation.setRelationColumn(columnName);
        relation.setConditional(whereClauseForChildren);
        relation.setUnconditional(children);
        switch (operationType) {
            case ADD_RELATION: {
                this.operations.add((Operation)new OperationAddRelation(operationType, parentTable, operationResultId, relation));
                break;
            }
            case SET_RELATION: {
                this.operations.add((Operation)new OperationSetRelation(operationType, parentTable, operationResultId, relation));
                break;
            }
            case DELETE_RELATION: {
                this.operations.add((Operation)new OperationDeleteRelation(operationType, parentTable, operationResultId, relation));
            }
        }
        return TransactionHelper.makeOpResult(parentTable, operationResultId, operationType);
    }

    private void checkOpResultFoParent(OpResult parentObject) {
        if (parentObject == null) {
            throw new IllegalArgumentException("OpResult can not be null");
        }
        if (!OperationType.supportEntityDescriptionResultType.contains(parentObject.getOperationType())) {
            throw new IllegalArgumentException("This operation result not supported in this operation");
        }
    }

    private <E> String getParentObjectIdFromInstance(E parentObject) {
        if (parentObject == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        String parentObjectId = Persistence.getEntityId(parentObject);
        if (parentObjectId == null) {
            throw new IllegalArgumentException("Instance must contain objectId and objectId can not be null");
        }
        return parentObjectId;
    }

    private Map<String, Object> getReferenceToParentFromOpResultValue(OpResultValueReference parentObject) {
        if (parentObject == null) {
            throw new IllegalArgumentException("OpResultValueReference can not be null");
        }
        if (parentObject.getResultIndex() == null || parentObject.getPropName() != null) {
            throw new IllegalArgumentException("Cannot use OpResultValueReference which references a primitive value. It must point to a complete object.");
        }
        return TransactionHelper.convertCreateBulkOrFindResultIndexToObjectId(parentObject);
    }

    private Object makeChildren(OpResult children) {
        if (children == null) {
            throw new IllegalArgumentException("OpResult can not be null");
        }
        if (OperationType.supportCollectionEntityDescriptionType.contains(children.getOperationType()) || OperationType.supportListIdsResultType.contains(children.getOperationType())) {
            return children.makeReference();
        }
        if (OperationType.supportEntityDescriptionResultType.contains(children.getOperationType())) {
            return Collections.singletonList(children.resolveTo("objectId").makeReference());
        }
        throw new IllegalArgumentException("This operation result not supported in this operation");
    }

    private List<Object> getChildrenFromListMap(List<Map<String, Object>> childrenMaps) {
        if (childrenMaps == null || childrenMaps.isEmpty()) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        return TransactionHelper.convertMapsToObjectIds(childrenMaps);
    }

    private <E> List<String> getChildrenFromArrayInstances(E[] children) {
        if (children == null || children.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        return TransactionHelper.getObjectIdsFromListInstances(children);
    }
}

