/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.transaction;

import com.backendless.persistence.BackendlessSerializer;
import com.backendless.utils.MapEntityUtil;
import java.lang.reflect.Constructor;
import java.util.Map;

class SerializationHelper {
    SerializationHelper() {
    }

    static <E> Map<String, Object> serializeEntityToMap(E entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        SerializationHelper.checkDeclaredType(entity.getClass());
        Map<String, Object> serializedEntity = BackendlessSerializer.serializeToMap(entity);
        MapEntityUtil.removeNullsAndRelations(serializedEntity);
        return serializedEntity;
    }

    private static <T> void checkDeclaredType(Class<T> entityClass) {
        if (entityClass.isArray() || entityClass.isAssignableFrom(Iterable.class) || entityClass.isAssignableFrom(Map.class)) {
            throw new IllegalArgumentException("Wrong entity type");
        }
        try {
            Constructor<?>[] constructors = entityClass.getConstructors();
            if (constructors.length > 0) {
                entityClass.getConstructor(new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Missing public, default no-argument constructor");
        }
    }
}

