/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.transaction;

import com.backendless.transaction.OpResult;
import com.backendless.transaction.OpResultValueReference;
import com.backendless.transaction.OperationType;
import com.backendless.transaction.SerializationHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class TransactionHelper {
    private static final String LAST_LOGIN_COLUMN_NAME = "lastLogin";
    private static final String PASSWORD_KEY = "password";
    private static final String SOCIAL_ACCOUNT_COLUMN_NAME = "socialAccount";
    private static final String USER_STATUS_COLUMN_NAME = "userStatus";

    TransactionHelper() {
    }

    static void removeSystemField(Map<String, Object> changes) {
        changes.remove(LAST_LOGIN_COLUMN_NAME);
        changes.remove(PASSWORD_KEY);
        changes.remove(SOCIAL_ACCOUNT_COLUMN_NAME);
        changes.remove(USER_STATUS_COLUMN_NAME);
        changes.remove("objectId");
        changes.remove("created");
        changes.remove("updated");
    }

    static OpResult makeOpResult(String tableName, String operationResultId, OperationType operationType) {
        return new OpResult(tableName, operationType, operationResultId);
    }

    static <E> List<Map<String, Object>> convertInstancesToMaps(List<E> instances) {
        if (instances == null || instances.isEmpty()) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        ArrayList<Map<String, Object>> serializedEntities = new ArrayList<Map<String, Object>>();
        for (E entity : instances) {
            serializedEntities.add(SerializationHelper.serializeEntityToMap(entity));
        }
        return serializedEntities;
    }

    static List<String> convertInstancesMapsToObjectIds(List<Map<String, Object>> objectsMaps) {
        ArrayList<String> objectIds = new ArrayList<String>();
        for (Map<String, Object> objectMap : objectsMaps) {
            objectIds.add(TransactionHelper.convertObjectMapToObjectId(objectMap));
        }
        return objectIds;
    }

    static List<Object> convertMapsToObjectIds(List<Map<String, Object>> objectsMaps) {
        ArrayList<Object> objectIds = new ArrayList<Object>();
        for (Map<String, Object> objectMap : objectsMaps) {
            objectIds.add(TransactionHelper.convertObjectMapToObjectId(objectMap));
        }
        return objectIds;
    }

    static String convertObjectMapToObjectId(Map<String, Object> objectMap) {
        if (objectMap == null || objectMap.isEmpty()) {
            throw new IllegalArgumentException("Map cannot be null or empty");
        }
        Object maybeObjectId = objectMap.get("objectId");
        if (!(maybeObjectId instanceof String)) {
            throw new IllegalArgumentException("Object map must contain string objectId and objectId can not be null");
        }
        return (String)maybeObjectId;
    }

    static <E> List<String> getObjectIdsFromListInstances(E[] children) {
        if (children[0] instanceof Map) {
            throw new IllegalArgumentException("Unable to execute the relation operation. Use the relation method which accepts list of Maps child objects");
        }
        if (!children[0].getClass().isArray() && !children[0].getClass().isAssignableFrom(Iterable.class)) {
            return TransactionHelper.convertInstancesMapsToObjectIds(TransactionHelper.convertInstancesToMaps(Arrays.asList(children)));
        }
        throw new IllegalArgumentException("Array can be only of instances");
    }

    static Map<String, Object> convertCreateBulkOrFindResultIndexToObjectId(OpResultValueReference parentObject) {
        Map<String, Object> referenceToObjectId;
        if (OperationType.supportCollectionEntityDescriptionType.contains(parentObject.getOpResult().getOperationType())) {
            referenceToObjectId = parentObject.resolveTo("objectId").makeReference();
        } else if (OperationType.supportListIdsResultType.contains(parentObject.getOpResult().getOperationType())) {
            referenceToObjectId = parentObject.makeReference();
        } else {
            throw new IllegalArgumentException("This operation result not supported in this operation");
        }
        return referenceToObjectId;
    }

    static void makeReferenceToValueFromOpResult(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof OpResult) {
                if (OperationType.supportIntResultType.contains(((OpResult)entry.getValue()).getOperationType())) {
                    entry.setValue(((OpResult)entry.getValue()).makeReference());
                } else {
                    throw new IllegalArgumentException("OpResult/OpResultValueReference from this operation in this place not supported");
                }
            }
            if (!(entry.getValue() instanceof OpResultValueReference)) continue;
            OpResultValueReference reference = (OpResultValueReference)entry.getValue();
            if (TransactionHelper.createUpdatePropName(reference) || TransactionHelper.createBulkResultIndex(reference) || TransactionHelper.findPropNameResultIndex(reference)) {
                entry.setValue(reference.makeReference());
                continue;
            }
            throw new IllegalArgumentException("OpResult/OpResultValueReference from this operation in this place not supported");
        }
    }

    private static boolean createUpdatePropName(OpResultValueReference reference) {
        return OperationType.supportEntityDescriptionResultType.contains(reference.getOpResult().getOperationType()) && reference.getPropName() != null && reference.getResultIndex() == null;
    }

    private static boolean createBulkResultIndex(OpResultValueReference reference) {
        return OperationType.CREATE_BULK.equals((Object)reference.getOpResult().getOperationType()) && reference.getPropName() == null && reference.getResultIndex() != null;
    }

    private static boolean findPropNameResultIndex(OpResultValueReference reference) {
        return OperationType.FIND.equals((Object)reference.getOpResult().getOperationType()) && reference.getPropName() != null && reference.getResultIndex() != null;
    }
}

