/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.transaction;

import com.backendless.persistence.BackendlessSerializer;
import com.backendless.transaction.OpResult;
import com.backendless.transaction.OpResultIdGenerator;
import com.backendless.transaction.Operation;
import com.backendless.transaction.OperationCreate;
import com.backendless.transaction.OperationCreateBulk;
import com.backendless.transaction.OperationType;
import com.backendless.transaction.SerializationHelper;
import com.backendless.transaction.TransactionHelper;
import com.backendless.transaction.UnitOfWorkCreate;
import java.util.List;
import java.util.Map;

class UnitOfWorkCreateImpl
implements UnitOfWorkCreate {
    private final List<Operation> operations;
    private final OpResultIdGenerator opResultIdGenerator;
    private final Map<String, Class> clazzes;

    UnitOfWorkCreateImpl(List<Operation> operations, OpResultIdGenerator opResultIdGenerator, Map<String, Class> clazzes) {
        this.operations = operations;
        this.opResultIdGenerator = opResultIdGenerator;
        this.clazzes = clazzes;
    }

    @Override
    public <E> OpResult create(E instance) {
        Map<String, Object> entityMap = SerializationHelper.serializeEntityToMap(instance);
        String tableName = BackendlessSerializer.getSimpleName(instance.getClass());
        this.clazzes.put(tableName, instance.getClass());
        return this.create(tableName, entityMap);
    }

    @Override
    public OpResult create(String tableName, Map<String, Object> objectMap) {
        if (objectMap == null) {
            throw new IllegalArgumentException("Entity map cannot be null");
        }
        TransactionHelper.makeReferenceToValueFromOpResult(objectMap);
        String operationResultId = this.opResultIdGenerator.generateOpResultId(OperationType.CREATE, tableName);
        OperationCreate operationCreate = new OperationCreate(OperationType.CREATE, tableName, operationResultId, objectMap);
        this.operations.add((Operation)operationCreate);
        return TransactionHelper.makeOpResult(tableName, operationResultId, OperationType.CREATE);
    }

    @Override
    public <E> OpResult bulkCreate(List<E> instances) {
        List<Map<String, Object>> serializedEntities = TransactionHelper.convertInstancesToMaps(instances);
        String tableName = BackendlessSerializer.getSimpleName(instances.get(0).getClass());
        return this.bulkCreate(tableName, serializedEntities);
    }

    @Override
    public OpResult bulkCreate(String tableName, List<Map<String, Object>> arrayOfObjectMaps) {
        if (arrayOfObjectMaps == null || arrayOfObjectMaps.isEmpty()) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        for (Map<String, Object> mapObject : arrayOfObjectMaps) {
            if (mapObject != null) {
                TransactionHelper.makeReferenceToValueFromOpResult(mapObject);
                continue;
            }
            throw new IllegalArgumentException("Entity map cannot be null");
        }
        String operationResultId = this.opResultIdGenerator.generateOpResultId(OperationType.CREATE_BULK, tableName);
        OperationCreateBulk operationCreateBulk = new OperationCreateBulk(OperationType.CREATE_BULK, tableName, operationResultId, arrayOfObjectMaps);
        this.operations.add((Operation)operationCreateBulk);
        return TransactionHelper.makeOpResult(tableName, operationResultId, OperationType.CREATE_BULK);
    }
}

