/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.transaction;

import com.backendless.persistence.BackendlessSerializer;
import com.backendless.transaction.OpResult;
import com.backendless.transaction.OpResultIdGenerator;
import com.backendless.transaction.OpResultValueReference;
import com.backendless.transaction.Operation;
import com.backendless.transaction.OperationDelete;
import com.backendless.transaction.OperationDeleteBulk;
import com.backendless.transaction.OperationType;
import com.backendless.transaction.SerializationHelper;
import com.backendless.transaction.TransactionHelper;
import com.backendless.transaction.UnitOfWorkDelete;
import com.backendless.transaction.payload.DeleteBulkPayload;
import java.util.List;
import java.util.Map;

class UnitOfWorkDeleteImpl
implements UnitOfWorkDelete {
    private final List<Operation> operations;
    private final OpResultIdGenerator opResultIdGenerator;

    UnitOfWorkDeleteImpl(List<Operation> operations, OpResultIdGenerator opResultIdGenerator) {
        this.operations = operations;
        this.opResultIdGenerator = opResultIdGenerator;
    }

    @Override
    public <E> OpResult delete(E instance) {
        Map<String, Object> entityMap = SerializationHelper.serializeEntityToMap(instance);
        String tableName = BackendlessSerializer.getSimpleName(instance.getClass());
        return this.delete(tableName, entityMap);
    }

    @Override
    public OpResult delete(String tableName, Map<String, Object> objectMap) {
        String objectId = TransactionHelper.convertObjectMapToObjectId(objectMap);
        return this.delete(tableName, objectId);
    }

    @Override
    public OpResult delete(String tableName, String objectId) {
        String operationResultId = this.opResultIdGenerator.generateOpResultId(OperationType.DELETE, tableName);
        OperationDelete operationDelete = new OperationDelete(OperationType.DELETE, tableName, operationResultId, (Object)objectId);
        this.operations.add((Operation)operationDelete);
        return TransactionHelper.makeOpResult(tableName, operationResultId, OperationType.DELETE);
    }

    @Override
    public OpResult delete(OpResult result) {
        if (result == null) {
            throw new IllegalArgumentException("OpResult can not be null");
        }
        if (!OperationType.supportEntityDescriptionResultType.contains(result.getOperationType())) {
            throw new IllegalArgumentException("This operation result not supported in this operation");
        }
        String operationResultId = this.opResultIdGenerator.generateOpResultId(OperationType.DELETE, result.getTableName());
        OperationDelete operationDelete = new OperationDelete(OperationType.DELETE, result.getTableName(), operationResultId, result.resolveTo("objectId").makeReference());
        this.operations.add((Operation)operationDelete);
        return TransactionHelper.makeOpResult(result.getTableName(), operationResultId, OperationType.DELETE);
    }

    @Override
    public OpResult delete(OpResultValueReference resultIndex) {
        if (resultIndex == null) {
            throw new IllegalArgumentException("OpResultValueReference can not be null");
        }
        if (resultIndex.getResultIndex() == null || resultIndex.getPropName() != null) {
            throw new IllegalArgumentException("Cannot use OpResultValueReference which references a primitive value. It must point to a complete object.");
        }
        Map<String, Object> referenceToObjectId = TransactionHelper.convertCreateBulkOrFindResultIndexToObjectId(resultIndex);
        String operationResultId = this.opResultIdGenerator.generateOpResultId(OperationType.DELETE, resultIndex.getOpResult().getTableName());
        OperationDelete operationDelete = new OperationDelete(OperationType.DELETE, resultIndex.getOpResult().getTableName(), operationResultId, referenceToObjectId);
        this.operations.add((Operation)operationDelete);
        return TransactionHelper.makeOpResult(resultIndex.getOpResult().getTableName(), operationResultId, OperationType.DELETE);
    }

    @Override
    public <E> OpResult bulkDelete(List<E> instances) {
        if (instances == null || instances.isEmpty()) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        if (instances.get(0) instanceof Map) {
            throw new IllegalArgumentException("Unable to execute the bulkDelete operation. Use the bulkDelete method which accepts both table name and a collection of objects.");
        }
        if (instances.get(0) instanceof String) {
            throw new IllegalArgumentException("Unable to execute the bulkDelete operation. Use the bulkDelete method which accepts both table name and a collection of objectId values.");
        }
        List<Map<String, Object>> serializedEntities = TransactionHelper.convertInstancesToMaps(instances);
        String tableName = BackendlessSerializer.getSimpleName(instances.get(0).getClass());
        return this.bulkDelete(tableName, serializedEntities);
    }

    @Override
    public OpResult bulkDelete(String tableName, String[] objectIdValues) {
        if (objectIdValues == null || objectIdValues.length == 0) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        return this.bulkDelete(tableName, null, objectIdValues);
    }

    @Override
    public OpResult bulkDelete(String tableName, List<Map<String, Object>> arrayOfObjects) {
        if (arrayOfObjects == null || arrayOfObjects.isEmpty()) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        List<Object> objectIds = TransactionHelper.convertMapsToObjectIds(arrayOfObjects);
        return this.bulkDelete(tableName, null, objectIds);
    }

    @Override
    public OpResult bulkDelete(String tableName, String whereClause) {
        if (whereClause == null) {
            throw new IllegalArgumentException("WhereClause can not be null");
        }
        return this.bulkDelete(tableName, whereClause, null);
    }

    @Override
    public OpResult bulkDelete(OpResult result) {
        if (result == null) {
            throw new IllegalArgumentException("OpResult can not be null");
        }
        if (!OperationType.supportCollectionEntityDescriptionType.contains(result.getOperationType()) && !OperationType.supportListIdsResultType.contains(result.getOperationType())) {
            throw new IllegalArgumentException("This operation result not supported in this operation");
        }
        return this.bulkDelete(result.getTableName(), null, result.makeReference());
    }

    private OpResult bulkDelete(String tableName, String whereClause, Object unconditional) {
        String operationResultId = this.opResultIdGenerator.generateOpResultId(OperationType.DELETE_BULK, tableName);
        DeleteBulkPayload deleteBulkPayload = new DeleteBulkPayload(whereClause, unconditional);
        OperationDeleteBulk operationDeleteBulk = new OperationDeleteBulk(OperationType.DELETE_BULK, tableName, operationResultId, deleteBulkPayload);
        this.operations.add((Operation)operationDeleteBulk);
        return TransactionHelper.makeOpResult(tableName, operationResultId, OperationType.DELETE_BULK);
    }
}

