/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.transaction;

import com.backendless.persistence.BackendlessDataQuery;
import com.backendless.persistence.DataQueryBuilder;
import com.backendless.transaction.OpResult;
import com.backendless.transaction.OpResultIdGenerator;
import com.backendless.transaction.Operation;
import com.backendless.transaction.OperationFind;
import com.backendless.transaction.OperationType;
import com.backendless.transaction.TransactionHelper;
import com.backendless.transaction.UnitOfWorkFind;
import java.util.List;

class UnitOfWorkFindImpl
implements UnitOfWorkFind {
    private final List<Operation> operations;
    private final OpResultIdGenerator opResultIdGenerator;

    UnitOfWorkFindImpl(List<Operation> operations, OpResultIdGenerator opResultIdGenerator) {
        this.operations = operations;
        this.opResultIdGenerator = opResultIdGenerator;
    }

    @Override
    public OpResult find(String tableName, DataQueryBuilder queryBuilder) {
        BackendlessDataQuery query = queryBuilder.build();
        String operationResultId = this.opResultIdGenerator.generateOpResultId(OperationType.FIND, tableName);
        OperationFind operationFind = new OperationFind(OperationType.FIND, tableName, operationResultId, (Object)query);
        this.operations.add((Operation)operationFind);
        return TransactionHelper.makeOpResult(tableName, operationResultId, OperationType.FIND);
    }
}

