/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.transaction;

import com.backendless.persistence.BackendlessSerializer;
import com.backendless.transaction.OpResult;
import com.backendless.transaction.OpResultIdGenerator;
import com.backendless.transaction.OpResultValueReference;
import com.backendless.transaction.Operation;
import com.backendless.transaction.OperationType;
import com.backendless.transaction.OperationUpdate;
import com.backendless.transaction.OperationUpdateBulk;
import com.backendless.transaction.SerializationHelper;
import com.backendless.transaction.TransactionHelper;
import com.backendless.transaction.UnitOfWorkUpdate;
import com.backendless.transaction.payload.UpdateBulkPayload;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class UnitOfWorkUpdateImpl
implements UnitOfWorkUpdate {
    private final List<Operation> operations;
    private final OpResultIdGenerator opResultIdGenerator;
    private final Map<String, Class> clazzes;

    UnitOfWorkUpdateImpl(List<Operation> operations, OpResultIdGenerator opResultIdGenerator, Map<String, Class> clazzes) {
        this.operations = operations;
        this.opResultIdGenerator = opResultIdGenerator;
        this.clazzes = clazzes;
    }

    @Override
    public <E> OpResult update(E instance) {
        Map<String, Object> entityMap = SerializationHelper.serializeEntityToMap(instance);
        String tableName = BackendlessSerializer.getSimpleName(instance.getClass());
        this.clazzes.put(tableName, instance.getClass());
        return this.update(tableName, entityMap);
    }

    @Override
    public OpResult update(OpResult result, String propertyName, Object propertyValue) {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put(propertyName, propertyValue);
        return this.update(result, changes);
    }

    @Override
    public OpResult update(OpResult result, Map<String, Object> changes) {
        if (result == null) {
            throw new IllegalArgumentException("OpResult can not be null");
        }
        if (!OperationType.supportEntityDescriptionResultType.contains(result.getOperationType())) {
            throw new IllegalArgumentException("This operation result not supported in this operation");
        }
        changes.put("objectId", result.resolveTo("objectId").makeReference());
        return this.update(result.getTableName(), changes);
    }

    @Override
    public OpResult update(OpResultValueReference result, String propertyName, Object propertyValue) {
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put(propertyName, propertyValue);
        return this.update(result, changes);
    }

    @Override
    public OpResult update(OpResultValueReference result, Map<String, Object> changes) {
        if (result == null) {
            throw new IllegalArgumentException("OpResult can not be null");
        }
        if (result.getResultIndex() == null || result.getPropName() != null) {
            throw new IllegalArgumentException("Cannot use OpResultValueReference which references a primitive value. It must point to a complete object.");
        }
        if (OperationType.supportCollectionEntityDescriptionType.contains(result.getOpResult().getOperationType())) {
            changes.put("objectId", result.resolveTo("objectId").makeReference());
        } else if (OperationType.supportListIdsResultType.contains(result.getOpResult().getOperationType())) {
            changes.put("objectId", result.makeReference());
        } else {
            throw new IllegalArgumentException("This operation result not supported in this operation");
        }
        return this.update(result.getOpResult().getTableName(), changes);
    }

    @Override
    public OpResult update(String tableName, Map<String, Object> objectMap) {
        if (objectMap == null || objectMap.isEmpty()) {
            throw new IllegalArgumentException("Map cannot be null or empty");
        }
        TransactionHelper.makeReferenceToValueFromOpResult(objectMap);
        String operationResultId = this.opResultIdGenerator.generateOpResultId(OperationType.UPDATE, tableName);
        OperationUpdate operationUpdate = new OperationUpdate(OperationType.UPDATE, tableName, operationResultId, objectMap);
        this.operations.add((Operation)operationUpdate);
        return TransactionHelper.makeOpResult(tableName, operationResultId, OperationType.UPDATE);
    }

    @Override
    public OpResult bulkUpdate(String tableName, String whereClause, Map<String, Object> changes) {
        return this.bulkUpdate(tableName, whereClause, null, changes);
    }

    @Override
    public OpResult bulkUpdate(String tableName, List<String> objectsForChanges, Map<String, Object> changes) {
        if (objectsForChanges == null || objectsForChanges.isEmpty()) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        return this.bulkUpdate(tableName, null, objectsForChanges, changes);
    }

    @Override
    public OpResult bulkUpdate(OpResult objectIdsForChanges, Map<String, Object> changes) {
        if (objectIdsForChanges == null) {
            throw new IllegalArgumentException("OpResult can not be null");
        }
        if (!OperationType.supportCollectionEntityDescriptionType.contains(objectIdsForChanges.getOperationType()) && !OperationType.supportListIdsResultType.contains(objectIdsForChanges.getOperationType())) {
            throw new IllegalArgumentException("This operation result not supported in this operation");
        }
        return this.bulkUpdate(objectIdsForChanges.getTableName(), null, objectIdsForChanges.makeReference(), changes);
    }

    private OpResult bulkUpdate(String tableName, String whereClause, Object objectsForChanges, Map<String, Object> changes) {
        if (changes == null || changes.isEmpty()) {
            throw new IllegalArgumentException("Map cannot be null or empty");
        }
        TransactionHelper.removeSystemField(changes);
        TransactionHelper.makeReferenceToValueFromOpResult(changes);
        String operationResultId = this.opResultIdGenerator.generateOpResultId(OperationType.UPDATE_BULK, tableName);
        UpdateBulkPayload updateBulkPayload = new UpdateBulkPayload(whereClause, objectsForChanges, changes);
        OperationUpdateBulk operationUpdateBulk = new OperationUpdateBulk(OperationType.UPDATE_BULK, tableName, operationResultId, updateBulkPayload);
        this.operations.add((Operation)operationUpdateBulk);
        return TransactionHelper.makeOpResult(tableName, operationResultId, OperationType.UPDATE_BULK);
    }
}

