/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.transaction;

import com.backendless.persistence.BackendlessSerializer;
import com.backendless.transaction.OpResult;
import com.backendless.transaction.OpResultIdGenerator;
import com.backendless.transaction.Operation;
import com.backendless.transaction.OperationType;
import com.backendless.transaction.OperationUpsert;
import com.backendless.transaction.OperationUpsertBulk;
import com.backendless.transaction.SerializationHelper;
import com.backendless.transaction.TransactionHelper;
import com.backendless.transaction.UnitOfWorkUpsert;
import java.util.List;
import java.util.Map;

public class UnitOfWorkUpsertImpl
implements UnitOfWorkUpsert {
    private final List<Operation> operations;
    private final OpResultIdGenerator opResultIdGenerator;
    private final Map<String, Class> clazzes;

    UnitOfWorkUpsertImpl(List<Operation> operations, OpResultIdGenerator opResultIdGenerator, Map<String, Class> clazzes) {
        this.operations = operations;
        this.opResultIdGenerator = opResultIdGenerator;
        this.clazzes = clazzes;
    }

    @Override
    public <E> OpResult upsert(E instance) {
        Map<String, Object> entityMap = SerializationHelper.serializeEntityToMap(instance);
        String tableName = BackendlessSerializer.getSimpleName(instance.getClass());
        this.clazzes.put(tableName, instance.getClass());
        return this.upsert(tableName, entityMap);
    }

    @Override
    public OpResult upsert(String tableName, Map<String, Object> objectMap) {
        if (objectMap == null) {
            throw new IllegalArgumentException("Entity map cannot be null");
        }
        TransactionHelper.makeReferenceToValueFromOpResult(objectMap);
        String operationResultId = this.opResultIdGenerator.generateOpResultId(OperationType.UPSERT, tableName);
        OperationUpsert OperationUpsert2 = new OperationUpsert(OperationType.UPSERT, tableName, operationResultId, objectMap);
        this.operations.add((Operation)OperationUpsert2);
        return TransactionHelper.makeOpResult(tableName, operationResultId, OperationType.UPSERT);
    }

    @Override
    public <E> OpResult bulkUpsert(List<E> instances) {
        List<Map<String, Object>> serializedEntities = TransactionHelper.convertInstancesToMaps(instances);
        String tableName = BackendlessSerializer.getSimpleName(instances.get(0).getClass());
        return this.bulkUpsert(tableName, serializedEntities);
    }

    @Override
    public OpResult bulkUpsert(String tableName, List<Map<String, Object>> arrayOfObjectMaps) {
        if (arrayOfObjectMaps == null || arrayOfObjectMaps.isEmpty()) {
            throw new IllegalArgumentException("Array of objects/maps cannot be null or empty");
        }
        for (Map<String, Object> mapObject : arrayOfObjectMaps) {
            if (mapObject != null) {
                TransactionHelper.makeReferenceToValueFromOpResult(mapObject);
                continue;
            }
            throw new IllegalArgumentException("Entity map cannot be null");
        }
        String operationResultId = this.opResultIdGenerator.generateOpResultId(OperationType.UPSERT_BULK, tableName);
        OperationUpsertBulk OperationUpsertBulk2 = new OperationUpsertBulk(OperationType.UPSERT_BULK, tableName, operationResultId, arrayOfObjectMaps);
        this.operations.add((Operation)OperationUpsertBulk2);
        return TransactionHelper.makeOpResult(tableName, operationResultId, OperationType.UPSERT_BULK);
    }
}

