/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.utils;

import com.backendless.async.callback.AsyncCallback;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ReflectionUtil {
    public static Object getFieldValue(Object object, String lowerKey, String upperKey) {
        if (object == null) {
            return null;
        }
        Method getMethod = ReflectionUtil.getMethod(object, "get" + lowerKey);
        if (getMethod == null) {
            getMethod = ReflectionUtil.getMethod(object, "get" + upperKey);
        }
        if (getMethod == null) {
            getMethod = ReflectionUtil.getMethod(object, "is" + lowerKey);
        }
        if (getMethod == null) {
            getMethod = ReflectionUtil.getMethod(object, "is" + upperKey);
        }
        if (getMethod != null) {
            try {
                return getMethod.invoke(object, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Field field = ReflectionUtil.getField(object.getClass(), lowerKey);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (NoSuchFieldException e1) {
            try {
                Field field = ReflectionUtil.getField(object.getClass(), upperKey);
                field.setAccessible(true);
                return field.get(object);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    private static Method getMethod(Object object, String methodName) {
        try {
            return object.getClass().getMethod(methodName, new Class[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            if (clazz.getSuperclass() != null) {
                return ReflectionUtil.getField(clazz.getSuperclass(), fieldName);
            }
            throw noSuchFieldException;
        }
    }

    public static boolean hasField(Class clazz, String fieldName) {
        try {
            clazz.getDeclaredField(fieldName);
            return true;
        }
        catch (NoSuchFieldException nfe) {
            if (clazz.getSuperclass() != null) {
                return ReflectionUtil.hasField(clazz.getSuperclass(), fieldName);
            }
            return false;
        }
    }

    public static <T> Class getCallbackGenericType(AsyncCallback<T> callback) {
        Type[] genericInterfaces = callback.getClass().getGenericInterfaces();
        Type asyncCallbackInterface = null;
        for (Type genericInterface : genericInterfaces) {
            Type rawType;
            if (!(genericInterface instanceof ParameterizedType) || !((rawType = ((ParameterizedType)genericInterface).getRawType()) instanceof Class) || !AsyncCallback.class.isAssignableFrom((Class)rawType)) continue;
            asyncCallbackInterface = genericInterface;
            break;
        }
        if (asyncCallbackInterface == null) {
            return Object.class;
        }
        Type type = ((ParameterizedType)asyncCallbackInterface).getActualTypeArguments()[0];
        if (type instanceof Class) {
            return (Class)type;
        }
        return Object.class;
    }
}

