/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.utils;

import com.backendless.core.responder.AdaptingResponder;
import com.backendless.core.responder.policy.CollectionAdaptingPolicy;
import com.backendless.core.responder.policy.DecoratorCachingAdaptingPolicy;
import com.backendless.core.responder.policy.GroupResultAdaptingPolicy;
import com.backendless.core.responder.policy.IAdaptingPolicy;
import com.backendless.core.responder.policy.PoJoAdaptingPolicy;
import com.backendless.core.responder.policy.SetAdaptingPolicy;
import com.backendless.exceptions.BackendlessException;
import com.backendless.persistence.BackendlessSerializer;
import java.util.Date;

public class ResponderHelper {
    public static <E> AdaptingResponder getCollectionAdaptingResponder(Class<E> entity) {
        entity = BackendlessSerializer.getClassForDeserialization(entity);
        return ResponderHelper.getAdaptingResponder(entity, new CollectionAdaptingPolicy());
    }

    public static <E> AdaptingResponder getSetAdaptingResponder(Class<E> entity) {
        entity = BackendlessSerializer.getClassForDeserialization(entity);
        return ResponderHelper.getAdaptingResponder(entity, new SetAdaptingPolicy());
    }

    public static <E> AdaptingResponder getGroupResultAdaptingResponder(Class<E> entity) {
        entity = BackendlessSerializer.getClassForDeserialization(entity);
        return ResponderHelper.getAdaptingResponder(entity, new GroupResultAdaptingPolicy());
    }

    public static <E> AdaptingResponder getPOJOAdaptingResponder(Class<E> entity) {
        entity = BackendlessSerializer.getClassForDeserialization(entity);
        return ResponderHelper.getAdaptingResponder(entity, new PoJoAdaptingPolicy());
    }

    public static <E> AdaptingResponder getAdaptingResponder(Class<E> entity, IAdaptingPolicy<E> policy) {
        if (ResponderHelper.needsPhantomCache(entity)) {
            policy = new DecoratorCachingAdaptingPolicy<E>(policy);
        }
        return new AdaptingResponder<E>(entity, policy);
    }

    public static <T> boolean needsPhantomCache(Class<T> entityClass) throws BackendlessException {
        try {
            if (!entityClass.getField("objectId").getType().equals(String.class)) {
                throw new IllegalArgumentException("Wrong type of the objectId field");
            }
            if (!entityClass.getField("__meta").getType().equals(String.class)) {
                throw new IllegalArgumentException("Wrong type of the meta field");
            }
            if (!entityClass.getField("created").getType().equals(Date.class)) {
                throw new IllegalArgumentException("Wrong type of the created field");
            }
            if (!entityClass.getField("updated").getType().equals(Date.class)) {
                throw new IllegalArgumentException("Wrong type of the updated field");
            }
        }
        catch (NoSuchFieldException e) {
            return true;
        }
        return false;
    }
}

