/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.utils.timeout;

import com.backendless.utils.timeout.TimeOutManager;

public class TimeOutManagerImpl
implements TimeOutManager {
    private static final int INITIAL_TIMEOUT = 200;
    private static final int MAX_TIMEOUT = 60000;
    private static final int REPEAT_TIMES_BEFORE_INCREASE = 10;
    private int repeatedTimes;
    private int currentTimeOut;

    public TimeOutManagerImpl() {
        this.reset();
    }

    @Override
    public int nextTimeout() {
        if (this.currentTimeOut > 60000) {
            return 60000;
        }
        if (this.repeatedTimes++ > 0 && this.repeatedTimes % 10 == 0) {
            this.currentTimeOut *= 2;
        }
        return this.currentTimeOut;
    }

    @Override
    public int repeatedTimes() {
        return this.repeatedTimes;
    }

    @Override
    public void reset() {
        this.repeatedTimes = 0;
        this.currentTimeOut = 200;
    }
}

