/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.simplegraph.sql;

import com.bitplan.simplegraph.core.SimpleNode;
import com.bitplan.simplegraph.sql.SQLSystem;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestSQLSystem {
    public static boolean debug = false;
    protected static Logger LOGGER = Logger.getLogger("com.bitplan.simplegraph.sql");
    private static final String DB_DRIVER = "org.h2.Driver";
    private static final String DB_CONNECTION = "jdbc:h2:mem:test";
    private static final String DB_USER = "";
    private static final String DB_PASSWORD = "";
    private String createSQL = "CREATE TABLE PERSON(id int primary key, name varchar(255), firstname varchar(255),email varchar(255))\nINSERT INTO PERSON(id, name,firstname,email) VALUES(1, 'Doe','John','john@doe.com')\nINSERT INTO PERSON(id, name,firstname,email) VALUES(2, 'Mayer','Tom','tom@mayer.com')\nINSERT INTO PERSON(id, name,firstname,email) VALUES(3, 'Ford','Bob','bob@ford.com')\n";

    public void checkSqlSystem(SQLSystem sql, String query, long expectedRecords) {
        sql.moveTo(query, new String[0]);
        long pCount = (Long)sql.getStartNode().g().V(new Object[0]).count().next();
        debug = true;
        if (debug) {
            System.out.println(String.format("found %3d records", pCount));
            sql.getStartNode().forAll(SimpleNode.printDebug);
        }
        Assert.assertEquals((String)"", (long)expectedRecords, (long)pCount);
    }

    @Test
    public void testSQL() throws Exception {
        SQLSystem sql = new SQLSystem();
        sql.connect(new String[]{DB_DRIVER, DB_CONNECTION, "", ""});
        sql.execute(this.createSQL);
        this.checkSqlSystem(sql, "select * from PERSON", 3L);
        sql.close(new String[0]);
    }

    @Test
    public void testSQLiteInMemory() throws Exception {
        SQLSystem sql = new SQLSystem();
        sql.connect(new String[]{"org.sqlite.JDBC", "jdbc:sqlite::memory:", "", ""});
        sql.execute(this.createSQL);
        this.checkSqlSystem(sql, "select * from PERSON", 3L);
        this.checkSqlSystem(sql, "PRAGMA table_info(PERSON)", 7L);
        sql.close(new String[0]);
    }
}

