/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.vzjava;

import com.bitplan.vzjava.Entities;
import com.bitplan.vzjava.PowerValue;
import com.bitplan.vzjava.Properties;
import com.bitplan.vzjava.jpa.EntitiesManagerDao;
import com.bitplan.vzjava.jpa.PropertiesManagerDao;
import com.bitplan.vzjava.jpa.VZDB;
import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Channel {
    protected static VZDB vzdb;
    protected static Logger LOGGER;
    protected static Map<String, Channel> channelsByTitle;
    Map<String, Properties> properties = new HashMap<String, Properties>();
    Entities entity;
    int no;

    public int getNo() {
        return this.no;
    }

    public void setNo(int no) {
        this.no = no;
    }

    public static List<Channel> getChannels() throws Exception {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        if (vzdb == null) {
            vzdb = new VZDB();
        }
        PropertiesManagerDao pm = new PropertiesManagerDao();
        EntitiesManagerDao em = new EntitiesManagerDao();
        int index = 0;
        for (Entities entity : em.getEntities(vzdb)) {
            Channel channel = new Channel();
            channel.entity = entity;
            for (Properties property : entity.getProperties()) {
                channel.properties.put(property.getPkey(), property);
            }
            if (!"channel".equals(entity.getEclass())) continue;
            channel.setNo(++index);
            channels.add(channel);
            channelsByTitle.put(channel.getTitle(), channel);
        }
        return channels;
    }

    public String getTitle() {
        String name = this.properties.get("title").getValue();
        return name;
    }

    public String getDescription() {
        String description = this.properties.get("description").getValue();
        return description;
    }

    public PowerValue.ChannelMode getChannelMode() {
        if ("powersensor".equals(this.entity.getType())) {
            return PowerValue.ChannelMode.Power;
        }
        if ("electric meter".equals(this.entity.getType())) {
            return PowerValue.ChannelMode.Counter;
        }
        LOGGER.log(Level.WARNING, "unknown entity type " + this.entity.getType() + " assuming counter");
        return PowerValue.ChannelMode.Counter;
    }

    public Paint getColor() {
        String colorString = this.properties.get("color").getValue();
        int r = Integer.parseInt(colorString.substring(1, 3), 16);
        int g = Integer.parseInt(colorString.substring(3, 5), 16);
        int b = Integer.parseInt(colorString.substring(5, 7), 16);
        Color color = new Color(r, g, b);
        return color;
    }

    static {
        LOGGER = Logger.getLogger("com.bitplan.vzjava");
        channelsByTitle = new HashMap<String, Channel>();
    }
}

