/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.vzjava;

import com.bitplan.vzjava.Channel;
import com.bitplan.vzjava.Plot;
import com.bitplan.vzjava.PowerValue;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class PowerValuePlot
extends Plot {
    List<Curve> curves = new ArrayList<Curve>();

    @Override
    public Plot.ColoredDataSet createDataset() {
        Plot.ColoredDataSet result = new Plot.ColoredDataSet(this);
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.setDomainIsPointsInTime(true);
        Paint[] colors = new Paint[this.curves.size()];
        int index = 0;
        for (Curve curve : this.curves) {
            colors[index] = curve.channel.getColor();
            TimeSeries series = new TimeSeries((Comparable)((Object)curve.channel.getTitle()), Minute.class);
            for (PowerValue powerValue : curve.powerValues) {
                Date ts = powerValue.getTimeStamp();
                Minute min = new Minute(ts);
                series.addOrUpdate((RegularTimePeriod)min, powerValue.getValue());
            }
            dataset.addSeries(series);
            ++index;
        }
        result.dataSet = dataset;
        result.paintSequence = colors;
        return result;
    }

    public void add(Channel channel, List<PowerValue> powervalues) {
        Curve curve = new Curve();
        curve.channel = channel;
        curve.powerValues = powervalues;
        this.curves.add(curve);
    }

    public static class Curve {
        Channel channel;
        List<PowerValue> powerValues;
    }
}

