/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.vzjava;

import com.bitplan.vzjava.Channel;
import com.bitplan.vzjava.PowerValue;
import com.bitplan.vzjava.PowerValuePlot;
import com.bitplan.vzjava.jpa.PowerValueManagerDao;
import com.bitplan.vzjava.jpa.VZDB;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PowerValuePlotManager {
    Path tmpDir = null;
    static PowerValuePlotManager instance;
    Map<String, File> plotFileCacheBySignature = new HashMap<String, File>();
    Map<String, File> plotFileCacheByName = new HashMap<String, File>();
    VZDB vzdb;

    public VZDB getVzdb() throws Exception {
        if (this.vzdb == null) {
            this.vzdb = new VZDB();
        }
        return this.vzdb;
    }

    public void setVzdb(VZDB vzdb) {
        this.vzdb = vzdb;
    }

    protected PowerValuePlotManager() {
    }

    public static PowerValuePlotManager getInstance() {
        if (instance == null) {
            instance = new PowerValuePlotManager();
        }
        return instance;
    }

    public Path getTempDirectory() throws Exception {
        if (this.tmpDir == null) {
            this.tmpDir = Files.createTempDirectory("powerRange", new FileAttribute[0]);
        }
        return this.tmpDir;
    }

    public File getPlot(String channelNos, String isoFrom, String isoTo, int width, int height) throws Exception {
        File plotFile;
        String signature = String.format("%s %s-%s %4d-%4d", channelNos, isoFrom, isoTo, width, height);
        if (this.plotFileCacheBySignature.containsKey(signature) && (plotFile = this.plotFileCacheBySignature.get(signature)).canRead()) {
            return plotFile;
        }
        PowerValuePlot pvplot = new PowerValuePlot();
        PowerValueManagerDao pvm = PowerValueManagerDao.getVZInstance(this.getVzdb());
        List<Channel> channels = Channel.getChannels();
        if (channelNos != null) {
            for (String channelNo : channelNos.split(";")) {
                int channelNumber = Integer.parseInt(channelNo);
                Channel channel = channels.get(channelNumber - 1);
                List<PowerValue> powervalues = pvm.get(isoFrom, isoTo, channelNumber, channel.getChannelMode());
                pvplot.add(channel, powervalues);
            }
        }
        File pngFile = Files.createTempFile(this.getTempDirectory(), "powerRange", ".png", new FileAttribute[0]).toFile();
        pvplot.saveAsPng(pngFile, width, height);
        this.plotFileCacheBySignature.put(signature, pngFile);
        this.plotFileCacheByName.put(pngFile.getName(), pngFile);
        return pngFile;
    }

    public File getPlotFile(String filename) {
        File pngFile = this.plotFileCacheByName.get(filename);
        return pngFile;
    }
}

