/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.vzjava.jpa;

import com.bitplan.vzjava.DBConfig;
import com.bitplan.vzjava.DBConfigImpl;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class VZDB {
    private EntityManagerFactory emf;
    private EntityManager em;
    private String PERSISTENCE_UNIT_NAME = "vz";
    private Map<String, String> properties = new HashMap<String, String>();
    private DBConfig dbConfig;

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public DBConfig getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(DBConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public VZDB() throws Exception {
        String configname = DBConfigImpl.getConfigName();
        this.init(configname);
    }

    public VZDB(String dbConfigName) throws Exception {
        this.init(dbConfigName);
    }

    public void init(String dbConfigName) throws Exception {
        this.dbConfig = DBConfigImpl.getDBConfig(dbConfigName);
        if (this.dbConfig == null) {
            this.dbConfig = new DBConfigImpl();
            this.dbConfig.setName("demo");
            Map emprops = this.getEntityManager().getProperties();
            this.dbConfig.setUrl((String)emprops.get("javax.persistence.jdbc.url"));
            this.dbConfig.setDriver((String)emprops.get("javax.persistence.jdbc.driver"));
            if (emprops.containsKey("javax.persistence.jdbc.user")) {
                this.dbConfig.setUser((String)emprops.get("javax.persistence.jdbc.user"));
            }
            if (emprops.containsKey("javax.persistence.jdbc.password")) {
                this.dbConfig.setPassword((String)emprops.get("javax.persistence.jdbc.password"));
                this.dbConfig.setPassword2(this.dbConfig.getPassword());
            }
        } else {
            String[] keys;
            Map dbConfigMap = this.dbConfig.asMap();
            for (String key : keys = new String[]{"driver", "url", "user", "password"}) {
                this.setProperty("javax.persistence.jdbc." + key, (String)dbConfigMap.get(key));
            }
        }
    }

    public EntityManager getEntityManager() {
        if (this.em == null) {
            this.emf = Persistence.createEntityManagerFactory((String)this.PERSISTENCE_UNIT_NAME, this.properties);
            this.em = this.emf.createEntityManager();
        }
        return this.em;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void close() {
        this.em.close();
        this.em = null;
        this.emf.close();
        this.emf = null;
    }
}

