/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.vzjava.resources;

import com.bitplan.vzjava.DBConfig;
import com.bitplan.vzjava.DBConfigImpl;
import com.bitplan.vzjava.jpa.VZDB;
import com.bitplan.vzjava.resources.VZResource;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Path(value="/dbconfig")
public class DBConfigResource
extends VZResource<DBConfig, DBConfig> {
    public DBConfigResource() {
        super.prepareRootMap("Datenbank-Einstellungen", "Datenbank-Einstellungen");
    }

    @GET
    @Path(value="{configname}")
    public Response showConfig(@PathParam(value="configname") String configname) throws Exception {
        VZDB vzdb = new VZDB(configname);
        this.rootMap.put("dc", vzdb.getDbConfig());
        Response response = super.templateResponse("dbconfig.rythm");
        return response;
    }

    @GET
    public Response showConfig() throws Exception {
        String configname = DBConfigImpl.getConfigName();
        return this.showConfig(configname);
    }

    public DBConfig fromForm(MultivaluedMap<String, String> formParams) {
        this.debug = true;
        Map dbConfigMap = super.asMap(formParams);
        DBConfigImpl dbConfig = new DBConfigImpl();
        dbConfig.fromMap(dbConfigMap);
        this.rootMap.put("dc", dbConfig);
        return dbConfig;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    @Path(value="{configname}")
    public Response workOnConfigFromPost(@PathParam(value="name") String configname, MultivaluedMap<String, String> formParams) {
        DBConfig dbConfig = this.fromForm(formParams);
        String cmd = (String)formParams.getFirst((Object)"cmd");
        if (("save".equals(cmd) || "test".equals(cmd)) && !dbConfig.getPassword().equals(dbConfig.getPassword2())) {
            this.rootMap.put("error", true);
            this.rootMap.put("message", "check passwords");
        }
        if (!this.rootMap.containsKey("error")) {
            if ("save".equals(cmd)) {
                try {
                    dbConfig.save();
                    this.rootMap.put("error", false);
                    this.rootMap.put("message", "saved");
                }
                catch (Throwable th) {
                    this.rootMap.put("error", true);
                    this.rootMap.put("message", th.getMessage());
                }
            } else if ("test".equals(cmd)) {
                try {
                    dbConfig.testConnection();
                    this.rootMap.put("error", false);
                    this.rootMap.put("message", "ok");
                }
                catch (Throwable th) {
                    this.rootMap.put("error", true);
                    this.rootMap.put("message", th.getMessage());
                }
            }
        }
        Response response = super.templateResponse("dbconfig.rythm");
        return response;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/html"})
    public Response workOnConfigFromPost(MultivaluedMap<String, String> formParams) {
        String configname = (String)formParams.getFirst((Object)"name");
        return this.workOnConfigFromPost(configname, formParams);
    }
}

