/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.vzjava.resources;

import com.bitplan.vzjava.PowerValuePlotManager;
import com.bitplan.vzjava.resources.VZResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.time.DateUtils;

@Path(value="/plot")
public class PowerPlotResource
extends VZResource {
    protected static Logger LOGGER = Logger.getLogger("com.bitplan.vzjava.resources");
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    public static final String[] DEFAULT_PATTERNS = new String[]{"EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};

    public PowerPlotResource() {
        super.prepareRootMap("Plot", "Plot");
    }

    @GET
    @Path(value="/range/{isoFrom}/{isoTo}/plot")
    @Produces(value={"image/png"})
    public Response getPlotFileForRange(@HeaderParam(value="If-Modified-Since") String modified, @QueryParam(value="width") @DefaultValue(value="1024") int width, @QueryParam(value="height") @DefaultValue(value="768") int height, @QueryParam(value="channelnos") String channelNos, @PathParam(value="isoFrom") String isoFrom, @PathParam(value="isoTo") String isoTo) throws Exception {
        File pngFile = PowerValuePlotManager.getInstance().getPlot(channelNos, isoFrom, isoTo, width, height);
        Response result = PowerPlotResource.returnFile(pngFile, modified);
        return result;
    }

    @GET
    @Path(value="/file/{filename}")
    public Response getPlotFileForRange(@HeaderParam(value="If-Modified-Since") String modified, @PathParam(value="filename") String filename) throws Exception {
        File pngFile = PowerValuePlotManager.getInstance().getPlotFile(filename);
        Response result = PowerPlotResource.returnFile(pngFile, modified);
        return result;
    }

    @GET
    @Path(value="/range/{isoFrom}/{isoTo}")
    public Response getPlotForRange(@QueryParam(value="width") @DefaultValue(value="1024") int width, @QueryParam(value="height") @DefaultValue(value="768") int height, @QueryParam(value="channelnos") String channelNos, @PathParam(value="isoFrom") String isoFrom, @PathParam(value="isoTo") String isoTo) throws Exception {
        File pngFile = PowerValuePlotManager.getInstance().getPlot(channelNos, isoFrom, isoTo, width, height);
        this.rootMap.put("isoFrom", isoFrom);
        this.rootMap.put("isoTo", isoTo);
        this.rootMap.put("pngFile", pngFile.getName());
        return super.templateResponse("plot.rythm");
    }

    public static Response returnFile(File file, String modified) {
        if (!file.exists()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (modified != null) {
            Date modifiedDate = null;
            Locale old = Locale.getDefault();
            Locale.setDefault(Locale.ENGLISH);
            try {
                modifiedDate = DateUtils.parseDate((String)modified, (String[])DEFAULT_PATTERNS);
            }
            catch (ParseException e) {
                LOGGER.log(Level.WARNING, e.getMessage());
            }
            Locale.setDefault(old);
            if (modifiedDate != null && file.lastModified() - modifiedDate.getTime() < 1000L) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
            }
        }
        try {
            Date fileDate = new Date(file.lastModified());
            return Response.ok((Object)new FileInputStream(file)).lastModified(fileDate).build();
        }
        catch (FileNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

