/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.vzjava;

import com.bitplan.vzjava.DBConfigImpl;
import com.bitplan.vzjava.ErrorHandler;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class AppMode {
    static File demoDb = new File("src/test/data/vzdb/vzdemo.db");
    static File testDb = new File("src/test/data/vzdb/vztest.db");
    static File demoDbRelease = new File("src/test/data/vzdb/vztest.db.release");

    public static Mode getMode() {
        if (!demoDb.exists()) {
            return Mode.Welcome;
        }
        if (testDb.exists()) {
            return Mode.Test;
        }
        if ("demo".equals(DBConfigImpl.getConfigName())) {
            return Mode.Demo;
        }
        return Mode.Operation;
    }

    public static void setMode(Mode mode) {
        try {
            switch (mode) {
                case Welcome: {
                    demoDb.delete();
                    break;
                }
                case Demo: {
                    testDb.delete();
                    FileUtils.copyFile((File)demoDbRelease, (File)demoDb);
                    break;
                }
                case Test: {
                    demoDb.delete();
                    FileUtils.copyFile((File)demoDbRelease, (File)testDb);
                }
                case Operation: {
                    break;
                }
            }
        }
        catch (IOException e) {
            ErrorHandler.handle(e);
        }
    }

    public static enum Mode {
        Welcome,
        Demo,
        Test,
        Operation;

    }
}

