/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.vzjava;

import com.bitplan.datatypes.DefaultTypeConverter;
import com.bitplan.datatypes.TypeConverter;
import com.bitplan.rest.Crypt;
import com.bitplan.rest.CryptImpl;
import com.bitplan.vzjava.DBConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBConfigImpl
implements DBConfig {
    protected static Logger LOGGER = Logger.getLogger("com.bitplan.vzjava");
    String name;
    String driver;
    String url;
    String user;
    String password;
    String password2;
    transient TypeConverter tc = new DefaultTypeConverter();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public void setDriver(String driver) {
        this.driver = driver;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getPassword2() {
        return this.password2;
    }

    @Override
    public void setPassword2(String password2) {
        this.password2 = password2;
    }

    public static PropInfo getIniInfo() {
        File iniFile = new File(DBConfigImpl.getIniPath(), "vzjava.ini");
        PropInfo propInfo = new PropInfo(iniFile);
        return propInfo;
    }

    public static PropInfo getConfigInfo(String configname) {
        File propertyFile = new File(DBConfigImpl.getIniPath(), "vzdb_" + configname + ".ini");
        PropInfo dbConfigInfo = new PropInfo(propertyFile);
        return dbConfigInfo;
    }

    public static String getConfigName() {
        PropInfo iniInfo = DBConfigImpl.getIniInfo();
        if (iniInfo.propMap == null) {
            return "demo";
        }
        return iniInfo.propMap.get("dbconfigname");
    }

    public static File getIniPath() {
        File iniPath = new File(System.getProperty("user.home") + "/.vzjava");
        if (!iniPath.isDirectory()) {
            iniPath.mkdirs();
        }
        return iniPath;
    }

    public static DBConfig getDBConfig(String dbConfigName) {
        DBConfigImpl dbConfig = null;
        PropInfo dbConfigInfo = DBConfigImpl.getConfigInfo(dbConfigName);
        if (dbConfigInfo.propMap != null) {
            dbConfig = new DBConfigImpl();
            dbConfig.fromMap(dbConfigInfo.propMap);
            try {
                String password = dbConfig.getPassword();
                if (password != null) {
                    dbConfig.setPassword(dbConfigInfo.getCrypt().decrypt(password));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "decrypting password fails " + e.getMessage());
            }
            dbConfig.setPassword2(dbConfig.getPassword());
        }
        return dbConfig;
    }

    @Override
    public void save() throws Exception {
        PropInfo dbConfigInfo = DBConfigImpl.getConfigInfo(this.getName());
        Map<String, String> map = this.asMap();
        map.remove("password2");
        map.put("password", dbConfigInfo.getCrypt().encrypt(this.getPassword()));
        dbConfigInfo.save(map);
        PropInfo iniInfo = DBConfigImpl.getIniInfo();
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("dbconfigname", this.getName());
        iniInfo.save(infoMap);
    }

    public void fromMap(Map<String, String> map) {
        if (map.containsKey("name")) {
            this.setName(this.tc.getString((Object)map.get("name")));
        } else {
            this.setName(null);
        }
        if (map.containsKey("driver")) {
            this.setDriver(this.tc.getString((Object)map.get("driver")));
        } else {
            this.setDriver(null);
        }
        if (map.containsKey("url")) {
            this.setUrl(this.tc.getString((Object)map.get("url")));
        } else {
            this.setUrl(null);
        }
        if (map.containsKey("user")) {
            this.setUser(this.tc.getString((Object)map.get("user")));
        } else {
            this.setUser(null);
        }
        if (map.containsKey("password")) {
            this.setPassword(this.tc.getString((Object)map.get("password")));
        } else {
            this.setPassword(null);
        }
        if (map.containsKey("password2")) {
            this.setPassword2(this.tc.getString((Object)map.get("password2")));
        } else {
            this.setPassword2(null);
        }
    }

    public Map<String, String> asMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", this.tc.fromNullValue(this.getName()));
        result.put("driver", this.tc.fromNullValue(this.getDriver()));
        result.put("url", this.tc.fromNullValue(this.getUrl()));
        result.put("user", this.tc.fromNullValue(this.getUser()));
        result.put("password", this.tc.fromNullValue(this.getPassword()));
        result.put("password2", this.tc.fromNullValue(this.getPassword2()));
        return result;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.tc = typeConverter;
    }

    public TypeConverter getTypeConverter() {
        return this.tc;
    }

    @Override
    public Properties testConnection() throws Exception {
        Class.forName(this.driver);
        Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
        Properties clientInfo = conn.getClientInfo();
        conn.close();
        return clientInfo;
    }

    public static class PropInfo {
        File propertyFile;
        Map<String, String> propMap;
        Properties jproperties = new Properties();

        public Crypt getCrypt() {
            CryptImpl pcf = new CryptImpl(this.propertyFile.getName() + "LBKMhYb57ljt5pR3rB14w9w7V1NWdojRa", "p3qzVBSR");
            return pcf;
        }

        public PropInfo(File propertyFile) {
            this.propertyFile = propertyFile;
            if (propertyFile.exists()) {
                this.propMap = new HashMap<String, String>();
                Properties jproperties = new Properties();
                try {
                    jproperties.load(new FileInputStream(propertyFile));
                    for (String key : jproperties.stringPropertyNames()) {
                        this.propMap.put(key, jproperties.getProperty(key));
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "error " + e.getMessage() + " for propertyFile " + propertyFile.getAbsolutePath());
                }
            }
        }

        public void save(Map<String, String> map) throws Exception {
            SimpleDateFormat isoDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String comments = String.format("saved %s ", isoDateFormatter.format(new Date()));
            PrintWriter writer = new PrintWriter(this.propertyFile);
            for (String key : map.keySet()) {
                this.jproperties.setProperty(key, map.get(key));
            }
            this.jproperties.store(writer, comments);
        }
    }
}

