/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.vzjava;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.xy.XYDataset;

public abstract class Plot {
    protected static Logger LOGGER = Logger.getLogger("com.bitplan.vzjava");
    public final boolean debug = false;
    protected String title;
    protected JFrame frame;
    protected ColoredDataSet dataset;
    protected JFreeChart chart = null;
    protected ChartPanel chartPanel;

    public JFreeChart getChart() {
        if (this.chart == null) {
            this.dataset = this.createDataset();
            this.chart = this.createChart(this.dataset);
        }
        return this.chart;
    }

    private JFreeChart createChart(ColoredDataSet cdataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)this.title, (String)"Time", (String)"Power", (XYDataset)cdataset.dataSet, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(false);
        XYItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof StandardXYItemRenderer) {
            renderer.setSeriesStroke(0, (Stroke)new BasicStroke(3.0f));
            renderer.setSeriesStroke(1, (Stroke)new BasicStroke(3.0f));
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("HH:mm"));
        DefaultDrawingSupplier supplier = new DefaultDrawingSupplier(cdataset.paintSequence, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
        chart.getPlot().setDrawingSupplier((DrawingSupplier)supplier);
        return chart;
    }

    public abstract ColoredDataSet createDataset();

    public void add(TimeSeries series, Date ts, Double value) {
        Minute min = new Minute(ts);
        series.addOrUpdate((RegularTimePeriod)min, (Number)value);
    }

    public ChartPanel getPanel() {
        this.chartPanel = new ChartPanel(this.getChart());
        return this.chartPanel;
    }

    public JFrame show() {
        this.frame = new JFrame(this.title);
        this.frame.setDefaultCloseOperation(1);
        this.frame.getContentPane().add((Component)this.getPanel(), "Center");
        this.frame.pack();
        this.frame.setVisible(true);
        return this.frame;
    }

    public void waitVisible() throws InterruptedException {
        while (this.chartPanel == null || !this.chartPanel.isVisible()) {
            Thread.sleep(50L);
        }
    }

    public void waitClose() throws InterruptedException {
        while (this.frame != null && this.frame.isVisible()) {
            Thread.sleep(50L);
        }
    }

    public void saveAsPng(File file, int width, int height) throws Exception {
        FileOutputStream outputstream = new FileOutputStream(file);
        ChartUtilities.writeChartAsPNG((OutputStream)outputstream, (JFreeChart)this.getChart(), (int)width, (int)height);
        outputstream.close();
    }

    public class ColoredDataSet {
        public XYDataset dataSet;
        public Paint[] paintSequence;
    }
}

