/*
 * Decompiled with CFR 0.152.
 */
package com.bitplan.vzjava.jpa;

import com.bitplan.datatypes.DefaultTypeConverter;
import com.bitplan.jaxb.JaxbFactory;
import com.bitplan.jaxb.JaxbFactoryApi;
import com.bitplan.jaxb.ManagerImpl;
import com.bitplan.vzjava.Entities;
import com.bitplan.vzjava.PowerValue;
import com.bitplan.vzjava.PowerValueImpl;
import com.bitplan.vzjava.PowerValueManager;
import com.bitplan.vzjava.jpa.EntitiesManagerDao;
import com.bitplan.vzjava.jpa.PowerValueDao;
import com.bitplan.vzjava.jpa.VZDB;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="powerValuesManager")
public class PowerValueManagerDao
extends ManagerImpl<PowerValueManager, PowerValue>
implements PowerValueManager {
    private static final double POWER_LIMIT = 32000.0;
    static SimpleDateFormat isoDateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static JaxbFactory<PowerValueManager> factory;
    protected transient VZDB vzdb;
    List<PowerValue> powerValues = new ArrayList<PowerValue>();

    public PowerValueManagerDao() {
    }

    public PowerValueManagerDao(VZDB lvzdb) {
        this.setVzdb(lvzdb);
    }

    @XmlElementWrapper(name="powerValues")
    @XmlElement(name="powerValue", type=PowerValueDao.class)
    public List<PowerValue> getPowerValues() {
        return this.powerValues;
    }

    @Override
    @XmlTransient
    public VZDB getVzdb() {
        return this.vzdb;
    }

    @Override
    public void setVzdb(VZDB vzdb) {
        this.vzdb = vzdb;
    }

    public void setPowerValues(List<PowerValue> PowerValue2) {
        this.powerValues = PowerValue2;
    }

    public List<PowerValue> getElements() {
        return this.getPowerValues();
    }

    public static JaxbFactoryApi<PowerValueManager> getFactoryStatic() {
        if (factory == null) {
            factory = new JaxbFactory(PowerValueManagerDao.class);
        }
        return factory;
    }

    public JaxbFactoryApi<PowerValueManager> getFactory() {
        return PowerValueManagerDao.getFactoryStatic();
    }

    @Override
    public List<PowerValue> get(String isoFrom, String isoTo, int channel, PowerValue.ChannelMode channelMode) throws Exception {
        DefaultTypeConverter tc = new DefaultTypeConverter();
        Date fromDate = tc.getDate((Object)isoFrom);
        Date toDate = tc.getDate((Object)isoTo);
        Calendar from = Calendar.getInstance();
        from.setTime(fromDate);
        Calendar to = Calendar.getInstance();
        to.setTime(toDate);
        List<PowerValue> result = this.get(from, to, channel, channelMode);
        return result;
    }

    public List<PowerValue> get(Calendar from, Calendar to, int channel, PowerValue.ChannelMode channelMode) {
        List<PowerValue> result = null;
        switch (channelMode) {
            case Power: {
                result = this.getPower(from, to, channel);
                break;
            }
            case Counter: {
                result = this.getPowerFromCounter(from, to, channel);
            }
        }
        return result;
    }

    public static double getPower(PowerValue chargeValue, PowerValue prevValue) {
        double z1 = chargeValue.getValue();
        double z2 = prevValue.getValue();
        long msecs = chargeValue.getTimeStamp().getTime() - prevValue.getTimeStamp().getTime();
        double diff = z1 - z2;
        double power = diff / ((double)msecs / 1000.0) * 3600.0;
        return power;
    }

    public List<PowerValue> getPower(Calendar from, Calendar to, int channel) {
        TypedQuery query = (TypedQuery)this.vzdb.getEntityManager().createNamedQuery("Data.period");
        query.setParameter(1, (Object)channel);
        query.setParameter(2, (Object)from.getTime().getTime());
        query.setParameter(3, (Object)to.getTime().getTime());
        List dataRecs = query.getResultList();
        ArrayList<PowerValue> chargeValues = new ArrayList<PowerValue>();
        for (PowerValue chargeValue : dataRecs) {
            chargeValues.add(chargeValue);
        }
        return chargeValues;
    }

    public PowerValue getCurrent(int channel) {
        EntitiesManagerDao emd = EntitiesManagerDao.getInstance();
        emd.getEntities(this.vzdb);
        Entities entity = emd.getEntityByChannel(channel);
        if (entity == null) {
            throw new RuntimeException("entity is null for channel " + channel);
        }
        TypedQuery query = (TypedQuery)this.vzdb.getEntityManager().createNamedQuery("Data.current");
        query.setParameter(1, (Object)channel);
        PowerValue powerValue = null;
        if ("powersensor".equals(entity.getType())) {
            query.setMaxResults(1);
            powerValue = (PowerValue)query.getSingleResult();
        } else {
            query.setMaxResults(2);
            List currentPowerValues = query.getResultList();
            PowerValueDao currentValue = (PowerValueDao)currentPowerValues.get(0);
            PowerValueDao prevValue = (PowerValueDao)currentPowerValues.get(1);
            powerValue = new PowerValueImpl();
            powerValue.setTimeStamp(currentValue.getTimeStamp());
            powerValue.setValue(PowerValueManagerDao.getPower(currentValue, prevValue));
        }
        return powerValue;
    }

    public List<PowerValue> getPowerFromCounter(Calendar from, Calendar to, int channel) {
        List<PowerValue> powerValues = this.getPower(from, to, channel);
        ArrayList<PowerValue> result = new ArrayList<PowerValue>();
        PowerValue prevValue = null;
        for (PowerValue chargeValue : powerValues) {
            double power;
            if (prevValue != null && Math.abs(power = PowerValueManagerDao.getPower(chargeValue, prevValue)) < 32000.0) {
                PowerValueImpl cv = new PowerValueImpl();
                cv.setTimeStamp(chargeValue.getTimeStamp());
                cv.setValue(power);
                result.add(cv);
            }
            prevValue = chargeValue;
        }
        return result;
    }

    public void add(PowerValue prop) {
        this.powerValues.add(prop);
    }

    public static PowerValueManagerDao getVZInstance() throws Exception {
        VZDB lvzdb = new VZDB();
        return PowerValueManagerDao.getVZInstance(lvzdb);
    }

    public static PowerValueManagerDao getVZInstance(VZDB pvzdb) throws Exception {
        PowerValueManagerDao pvm = new PowerValueManagerDao(pvzdb);
        return pvm;
    }
}

