/*
 * Decompiled with CFR 0.152.
 */
package com.blade.patchca;

import blade.kit.logging.Logger;
import blade.kit.logging.LoggerFactory;
import com.blade.web.http.Response;
import com.blade.web.http.wrapper.Session;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import org.patchca.color.ColorFactory;
import org.patchca.filter.FilterFactory;
import org.patchca.filter.predefined.DiffuseRippleFilterFactory;
import org.patchca.service.ConfigurableCaptchaService;
import org.patchca.utils.encoder.EncoderHelper;
import org.patchca.word.RandomWordFactory;
import org.patchca.word.WordFactory;

public class PatchcaService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchcaService.class);
    private ConfigurableCaptchaService cs = new ConfigurableCaptchaService();
    private static Random random = new Random();

    private PatchcaService() {
        this.cs.setColorFactory(new ColorFactory(){

            @Override
            public Color getColor(int x) {
                int[] c = new int[3];
                int i = random.nextInt(c.length);
                for (int fi = 0; fi < c.length; ++fi) {
                    c[fi] = fi == i ? random.nextInt(71) : random.nextInt(256);
                }
                return new Color(c[0], c[1], c[2]);
            }
        });
        RandomWordFactory wf = new RandomWordFactory();
        wf.setCharacters("23456789abcdefghigkmnpqrstuvwxyzABCDEFGHIGKLMNPQRSTUVWXYZ");
        wf.setMaxLength(4);
        wf.setMinLength(4);
        this.cs.setWordFactory(wf);
        this.cs.setFilterFactory(new DiffuseRippleFilterFactory());
    }

    public static PatchcaService get() {
        return new PatchcaService();
    }

    public PatchcaService color(ColorFactory colorFactory) {
        this.cs.setColorFactory(colorFactory);
        return this;
    }

    public PatchcaService word(WordFactory wordFactory) {
        this.cs.setWordFactory(wordFactory);
        return this;
    }

    public PatchcaService filter(FilterFactory filterFactory) {
        this.cs.setFilterFactory(filterFactory);
        return this;
    }

    public void session(Session session, Response response, String patchca) {
        try {
            this.setResponseHeaders(response);
            String token = EncoderHelper.getChallangeAndWriteImage(this.cs, "png", response.outputStream());
            session.attribute(patchca, (Object)token);
            LOGGER.debug("current sessionid = {}, token = {}", new Object[]{session.id(), token});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setResponseHeaders(Response response) {
        response.contentType("image/png");
        response.header("Cache-Control", "no-cache, no-store");
        response.header("Pragma", "no-cache");
        long time = System.currentTimeMillis();
        response.header("Last-Modified", time + "");
        response.header("Date", time + "");
        response.header("Expires", time + "");
    }

    public String token(String imgType, Response response) {
        try {
            String token = EncoderHelper.getChallangeAndWriteImage(this.cs, imgType, response.outputStream());
            return token;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String token(Response response) {
        try {
            String token = EncoderHelper.getChallangeAndWriteImage(this.cs, "png", response.outputStream());
            return token;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public File create(String imgPath, String imgType) {
        try {
            FileOutputStream fos = new FileOutputStream(imgPath);
            EncoderHelper.getChallangeAndWriteImage(this.cs, imgType, fos);
            fos.close();
            return new File(imgPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

