/*
 * Decompiled with CFR 0.152.
 */
package com.blockscore.net;

import com.blockscore.common.Constants;
import com.blockscore.models.Candidate;
import com.blockscore.models.Company;
import com.blockscore.models.PaginatedResult;
import com.blockscore.models.Person;
import com.blockscore.net.BlockscoreErrorHandler;
import com.blockscore.net.BlockscoreHttpClient;
import com.blockscore.net.BlockscoreRestAdapter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;
import retrofit.ErrorHandler;
import retrofit.RequestInterceptor;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.converter.Converter;
import retrofit.converter.JacksonConverter;

public class BlockscoreApiClient {
    private static RestAdapter.LogLevel logLevel = RestAdapter.LogLevel.NONE;
    private String apiKey;
    private final BlockscoreRestAdapter restAdapter;

    public static void useVerboseLogs(boolean useVerboseLogs) {
        logLevel = useVerboseLogs ? RestAdapter.LogLevel.FULL : RestAdapter.LogLevel.NONE;
    }

    public BlockscoreApiClient(@NotNull String apiKey) {
        this.apiKey = apiKey + ":";
        RestAdapter.Builder restBuilder = new RestAdapter.Builder().setClient((Client)new BlockscoreHttpClient()).setEndpoint("https://api.blockscore.com");
        restBuilder.setConverter((Converter)this.getDefaultConverter());
        restBuilder.setRequestInterceptor(this.getDefaultRequestInterceptor());
        restBuilder.setErrorHandler((ErrorHandler)new BlockscoreErrorHandler());
        restBuilder.setLogLevel(logLevel);
        this.restAdapter = (BlockscoreRestAdapter)restBuilder.build().create(BlockscoreRestAdapter.class);
    }

    @NotNull
    public Person retrievePerson(@NotNull String id) {
        Person person = this.restAdapter.retrievePerson(id);
        person.setAdapter(this.restAdapter);
        return person;
    }

    @NotNull
    public PaginatedResult<Person> listPeople() {
        PaginatedResult<Person> result = this.restAdapter.listPeople();
        for (Person person : result.getData()) {
            person.setAdapter(this.restAdapter);
        }
        return result;
    }

    @NotNull
    public Company retrieveCompany(@NotNull String id) {
        return this.restAdapter.retrieveCompany(id);
    }

    @NotNull
    public PaginatedResult<Company> listCompanies() {
        return this.restAdapter.listCompanies();
    }

    @NotNull
    public Candidate retrieveCandidate(@NotNull String id) {
        Candidate candidate = this.restAdapter.retrieveCandidate(id);
        candidate.setAdapter(this.restAdapter);
        return candidate;
    }

    @NotNull
    public PaginatedResult<Candidate> listCandidates() {
        PaginatedResult<Candidate> result = this.restAdapter.listCandidates();
        for (Candidate candidate : result.getData()) {
            candidate.setAdapter(this.restAdapter);
        }
        return result;
    }

    @NotNull
    private String getEncodedAuthorization() {
        try {
            return "Basic " + DatatypeConverter.printBase64Binary((byte[])this.apiKey.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private JacksonConverter getDefaultConverter() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibilityChecker(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        return new JacksonConverter(mapper);
    }

    private RequestInterceptor getDefaultRequestInterceptor() {
        return new RequestInterceptor(){

            public void intercept(RequestInterceptor.RequestFacade request) {
                request.addHeader("Authorization", BlockscoreApiClient.this.getEncodedAuthorization());
                request.addHeader("Accept", Constants.getAcceptHeaders());
            }
        };
    }

    public BlockscoreRestAdapter getAdapter() {
        return this.restAdapter;
    }
}

