/*
 * Decompiled with CFR 0.152.
 */
package com.blockscore.net;

import com.blockscore.exceptions.ApiException;
import com.blockscore.exceptions.InvalidRequestException;
import com.blockscore.models.error.BlockscoreError;
import com.blockscore.models.error.BlockscoreErrorType;
import com.blockscore.models.error.RequestError;
import retrofit.ErrorHandler;
import retrofit.RetrofitError;

class BlockscoreErrorHandler
implements ErrorHandler {
    BlockscoreErrorHandler() {
    }

    public Throwable handleError(RetrofitError cause) {
        Object rawError = cause.getBodyAs(BlockscoreError.class);
        if (rawError instanceof BlockscoreError) {
            BlockscoreError error = (BlockscoreError)rawError;
            RequestError requestError = error.getError();
            if (requestError.getErrorType() == BlockscoreErrorType.INVALID) {
                return new InvalidRequestException(error);
            }
            if (requestError.getErrorType() == BlockscoreErrorType.API) {
                return new ApiException(error);
            }
            String msg = String.format("An unknown error has occurred. Please contact support. Error type: %s", requestError.getErrorType().toString());
            return new RuntimeException(msg);
        }
        return cause;
    }
}

