/*
 * Decompiled with CFR 0.152.
 */
package com.blockscore.net;

import com.blockscore.net.UserAgentInterceptor;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import retrofit.client.Request;
import retrofit.client.UrlConnectionClient;

class BlockscoreHttpClient
extends UrlConnectionClient {
    private static final int CONNECT_TIMEOUT_MILLIS = 30000;
    private static final int READ_TIMEOUT_MILLIS = 30000;
    private final OkUrlFactory okUrlFactory;

    public BlockscoreHttpClient() {
        this.okUrlFactory = new OkUrlFactory(this.generateDefaultHttpClient());
    }

    public BlockscoreHttpClient(OkHttpClient client) {
        this.okUrlFactory = new OkUrlFactory(client);
    }

    private OkHttpClient generateDefaultHttpClient() {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(30000L, TimeUnit.MILLISECONDS);
        client.setReadTimeout(30000L, TimeUnit.MILLISECONDS);
        client.networkInterceptors().add(new UserAgentInterceptor("blockscore-java/4.0.1 (https://github.com/BlockScore/blockscore-java)"));
        return client;
    }

    protected HttpURLConnection openConnection(Request request) throws IOException {
        return this.okUrlFactory.open(new URL(request.getUrl()));
    }
}

