/*
 * Decompiled with CFR 0.152.
 */
package com.blockscore.net;

import com.blockscore.models.AnswerSet;
import com.blockscore.models.Candidate;
import com.blockscore.models.Company;
import com.blockscore.models.PaginatedResult;
import com.blockscore.models.Person;
import com.blockscore.models.QuestionSet;
import com.blockscore.models.WatchlistHit;
import com.blockscore.models.WatchlistSearchResults;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import retrofit.http.Body;
import retrofit.http.DELETE;
import retrofit.http.GET;
import retrofit.http.PATCH;
import retrofit.http.POST;
import retrofit.http.Path;
import retrofit.http.QueryMap;

public interface BlockscoreRestAdapter {
    @POST(value="/people")
    @NotNull
    public Person createPerson(@QueryMap @NotNull Map<String, String> var1);

    @GET(value="/people/{id}")
    @NotNull
    public Person retrievePerson(@Path(value="id") @NotNull String var1);

    @GET(value="/people")
    @NotNull
    public PaginatedResult<Person> listPeople();

    @POST(value="/question_sets")
    @NotNull
    public QuestionSet createQuestionSet(@QueryMap @NotNull Map<String, String> var1);

    @POST(value="/question_sets/{id}/score")
    @NotNull
    public QuestionSet scoreQuestionSet(@Path(value="id") @NotNull String var1, @Body @NotNull AnswerSet var2);

    @GET(value="/question_sets/{id}")
    @NotNull
    public QuestionSet retrieveQuestionSet(@Path(value="id") @NotNull String var1);

    @POST(value="/companies")
    public Company createCompany(@QueryMap @NotNull Map<String, String> var1);

    @GET(value="/companies/{id}")
    @NotNull
    public Company retrieveCompany(@Path(value="id") @NotNull String var1);

    @GET(value="/companies")
    @NotNull
    public PaginatedResult<Company> listCompanies();

    @POST(value="/candidates")
    @NotNull
    public Candidate createCandidate(@Body @NotNull Candidate var1);

    @GET(value="/candidates/{id}")
    @NotNull
    public Candidate retrieveCandidate(@Path(value="id") @NotNull String var1);

    @PATCH(value="/candidates/{id}")
    @NotNull
    public Candidate updateCandidate(@Path(value="id") @NotNull String var1, @Body @NotNull Candidate var2);

    @DELETE(value="/candidates/{id}")
    @NotNull
    public Candidate deleteCandidate(@Path(value="id") @NotNull String var1);

    @GET(value="/candidates")
    @NotNull
    public PaginatedResult<Candidate> listCandidates();

    @GET(value="/candidates/{id}/history")
    @NotNull
    public List<Candidate> getCandidateHistory(@Path(value="id") @NotNull String var1);

    @GET(value="/candidates/{id}/hits")
    @NotNull
    public PaginatedResult<WatchlistHit> getCandidateHits(@Path(value="id") @NotNull String var1);

    @POST(value="/watchlists")
    @NotNull
    public WatchlistSearchResults searchWatchlists(@QueryMap @NotNull Map<String, String> var1);
}

