/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.automate.model;

import com.browserstack.automate.AutomateClient;
import com.browserstack.automate.exception.AutomateException;
import com.browserstack.automate.exception.BuildNotFound;
import com.browserstack.automate.model.Session;
import com.browserstack.automate.model.SessionNode;
import com.browserstack.client.BrowserStackClient;
import com.browserstack.client.model.BrowserStackObject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Build
extends BrowserStackObject {
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="duration")
    private int duration;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="hashed_id")
    private String id;
    @JsonProperty(value="sessions")
    private List<Session> sessions;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Build() {
    }

    public Build(BrowserStackClient client, String buildId) {
        this.id = buildId;
        this.setClient(client);
    }

    public final boolean delete() throws AutomateException {
        return ((AutomateClient)this.getClient()).deleteBuild(this.getId());
    }

    @Override
    public <T> T setClient(BrowserStackClient client) {
        if (this.sessions != null) {
            for (Session session : this.sessions) {
                if (session == null) continue;
                session.setClient(client);
            }
        }
        return super.setClient(client);
    }

    @JsonProperty(value="hashed_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="hashed_id")
    private void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    private void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="duration")
    public int getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    private void setDuration(int duration) {
        this.duration = duration;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    private void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="sessions")
    public List<Session> getSessions() throws BuildNotFound, AutomateException {
        if (this.sessions == null) {
            this.sessions = ((AutomateClient)this.getClient()).getSessions(this.getId());
        }
        return this.sessions;
    }

    @JsonProperty(value="sessions")
    private void setSessions(List<SessionNode> sessionNodes) {
        ArrayList<Session> sessions = new ArrayList<Session>();
        if (sessionNodes != null) {
            for (SessionNode sessionNode : sessionNodes) {
                if (sessionNode == null || sessionNode.getSession() == null) continue;
                sessions.add(sessionNode.getSession());
            }
        }
        this.sessions = sessions;
    }

    @JsonAnyGetter
    protected Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    private void setAdditionalProperty(String name, Object value) {
        if (name != null && name.equals("automation_build") && value instanceof HashMap) {
            try {
                HashMap properties = (HashMap)value;
                if (properties.containsKey("hashed_id")) {
                    this.id = (String)properties.get("hashed_id");
                }
                if (properties.containsKey("name")) {
                    this.name = (String)properties.get("name");
                }
                if (properties.containsKey("status")) {
                    this.status = (String)properties.get("status");
                }
                if (properties.containsKey("duration")) {
                    this.duration = Integer.parseInt((String)properties.get("duration"));
                }
            }
            catch (RuntimeException runtimeException) {}
        } else {
            this.additionalProperties.put(name, value);
        }
    }
}

