/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.automate.model;

import com.browserstack.automate.Automate;
import com.browserstack.automate.AutomateClient;
import com.browserstack.automate.exception.AutomateException;
import com.browserstack.automate.exception.SessionNotFound;
import com.browserstack.client.BrowserStackClient;
import com.browserstack.client.model.BrowserStackObject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Session
extends BrowserStackObject {
    @JsonProperty(value="hashed_id")
    private String id;
    @JsonProperty(value="build_name")
    private String buildName;
    @JsonProperty(value="browser")
    private String browser;
    @JsonProperty(value="browser_version")
    private String browserVersion;
    @JsonProperty(value="os")
    private String os;
    @JsonProperty(value="os_version")
    private String osVersion;
    @JsonProperty(value="device")
    private String device;
    @JsonProperty(value="browser_url")
    private String browserUrl;
    @JsonProperty(value="public_url")
    private String publicUrl;
    @JsonProperty(value="video_url")
    private String videoUrl;
    @JsonProperty(value="logs")
    private String logUrl;
    @JsonProperty(value="project_name")
    private String projectName;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="reason")
    private String reason;
    @JsonProperty(value="duration")
    private Integer duration;
    @JsonProperty(value="name")
    private String name;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Session() {
    }

    public Session(BrowserStackClient client, String sessionId) {
        this.setClient(client);
        this.id = sessionId;
    }

    public final boolean delete() throws SessionNotFound, AutomateException {
        return ((AutomateClient)this.getClient()).deleteSession(this.getId());
    }

    public final Session updateStatus(Automate.SessionStatus sessionStatus, String reason) throws SessionNotFound, AutomateException {
        Session session = ((AutomateClient)this.getClient()).updateSessionStatus(this.getId(), sessionStatus, reason);
        if (session != null) {
            this.copyFrom(session);
        }
        return this;
    }

    public final Session updateStatus(Automate.SessionStatus sessionStatus) throws SessionNotFound, AutomateException {
        return this.updateStatus(sessionStatus, null);
    }

    public final String getLogs() throws AutomateException {
        if (this.logUrl == null) {
            throw new AutomateException("Session logs not found", 404);
        }
        return ((AutomateClient)this.getClient()).getSessionLogs(this);
    }

    @JsonProperty(value="hashed_id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="hashed_id")
    private void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="build_name")
    private String getBuildName() {
        return this.buildName;
    }

    @JsonProperty(value="build_name")
    private void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    @JsonProperty(value="browser")
    public String getBrowser() {
        return this.browser;
    }

    @JsonProperty(value="browser")
    private void setBrowser(String browser) {
        this.browser = browser;
    }

    @JsonProperty(value="browser_url")
    public String getBrowserUrl() {
        return this.browserUrl;
    }

    @JsonProperty(value="browser_url")
    private void setBrowserUrl(String browserUrl) {
        this.browserUrl = browserUrl;
    }

    @JsonProperty(value="public_url")
    public String getPublicUrl() {
        return this.publicUrl;
    }

    @JsonProperty(value="public_url")
    private void setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
    }

    @JsonProperty(value="video_url")
    public String getVideoUrl() {
        return this.videoUrl;
    }

    @JsonProperty(value="video_url")
    private void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
    }

    @JsonProperty(value="logs")
    public String getLogUrl() {
        return this.logUrl;
    }

    @JsonProperty(value="logs")
    private void setLogUrl(String logUrl) {
        this.logUrl = logUrl;
    }

    @JsonProperty(value="project_name")
    public String getProjectName() {
        return this.projectName;
    }

    @JsonProperty(value="project_name")
    private void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    private void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="browser_version")
    public String getBrowserVersion() {
        return this.browserVersion;
    }

    @JsonProperty(value="browser_version")
    private void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    @JsonProperty(value="os_version")
    public String getOsVersion() {
        return this.osVersion;
    }

    @JsonProperty(value="os_version")
    private void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    private void setReason(String reason) {
        this.reason = reason;
    }

    @JsonProperty(value="duration")
    public Integer getDuration() {
        return this.duration;
    }

    @JsonProperty(value="duration")
    private void setDuration(Integer duration) {
        this.duration = duration;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    private void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="device")
    public String getDevice() {
        return this.device;
    }

    @JsonProperty(value="device")
    private void setDevice(String device) {
        this.device = device;
    }

    @JsonProperty(value="os")
    public String getOs() {
        return this.os;
    }

    @JsonProperty(value="os")
    private void setOs(String os) {
        this.os = os;
    }

    @JsonAnyGetter
    protected Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    private void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    private boolean copyFrom(Session s) {
        if (s != null) {
            this.setName(s.getName());
            this.setProjectName(s.getProjectName());
            this.setBuildName(s.getBuildName());
            this.setOs(s.getOs());
            this.setOsVersion(s.getOsVersion());
            this.setBrowser(s.getBrowser());
            this.setBrowserVersion(s.getBrowserVersion());
            this.setDevice(s.getDevice());
            this.setBrowserUrl(s.getBrowserUrl());
            this.setDuration(s.getDuration());
            this.setLogUrl(s.getLogUrl());
            this.setStatus(s.getStatus());
            this.setReason(s.getReason());
            this.additionalProperties = s.getAdditionalProperties();
            return true;
        }
        return false;
    }
}

