/*
 * Decompiled with CFR 0.152.
 */
package com.browserstack.client;

import com.browserstack.client.BrowserStackRequest;
import com.browserstack.client.exception.BrowserStackException;
import com.browserstack.client.model.BrowserListing;
import com.browserstack.client.util.BrowserStackCache;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.ObjectParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BrowserStackClient {
    private static final String BASE_URL = "https://www.browserstack.com";
    private static final String CACHE_KEY_PREFIX_BROWSERS = "browsers";
    private static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final ObjectParser OBJECT_PARSER = new ObjectParser(){

        public <T> T parseAndClose(InputStream inputStream, Charset charset, Class<T> aClass) throws IOException {
            return (T)JSON_MAPPER.readValue(inputStream, aClass);
        }

        public <T> T parseAndClose(Reader reader, Class<T> aClass) throws IOException {
            return (T)JSON_MAPPER.readValue(reader, aClass);
        }

        public Object parseAndClose(InputStream inputStream, Charset charset, Type type) throws IOException {
            throw new IOException("Unsupported operation");
        }

        public Object parseAndClose(Reader reader, Type type) throws IOException {
            throw new IOException("Unsupported operation");
        }
    };
    protected final BrowserStackCache<String, Object> cacheMap = new BrowserStackCache();
    private final HttpRequestFactory requestFactory = BrowserStackClient.newRequestFactory();
    private String baseUrl;
    private String username;
    private String accessKey;
    private BasicAuthentication authentication;

    protected BrowserStackClient() {
    }

    public BrowserStackClient(String baseUrl, String username, String accessKey) {
        this();
        if (baseUrl == null) {
            throw new IllegalArgumentException("Invalid baseUrl");
        }
        if (username == null || username.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid username");
        }
        if (accessKey == null || accessKey.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid access key");
        }
        this.baseUrl = baseUrl;
        this.username = username.trim();
        this.accessKey = accessKey.trim();
        this.authentication = new BasicAuthentication(this.username, this.accessKey);
    }

    protected String getAccessKey() {
        return this.accessKey;
    }

    protected synchronized void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
        this.authentication = new BasicAuthentication(this.username, this.accessKey);
    }

    static HttpRequestFactory newRequestFactory() {
        return HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest httpRequest) throws IOException {
                httpRequest.setParser(OBJECT_PARSER);
            }
        });
    }

    static HttpRequest newRequest(HttpRequestFactory requestFactory, Method method, GenericUrl url) throws BrowserStackException {
        HttpRequest request;
        if (method == null) {
            throw new IllegalArgumentException("Invalid method");
        }
        try {
            switch (method) {
                case GET: {
                    request = requestFactory.buildGetRequest(url);
                    break;
                }
                case POST: {
                    request = requestFactory.buildPostRequest(url, null);
                    break;
                }
                case PUT: {
                    request = requestFactory.buildPutRequest(url, null);
                    break;
                }
                case DELETE: {
                    request = requestFactory.buildDeleteRequest(url);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid method");
                }
            }
        }
        catch (IOException e) {
            throw new BrowserStackException(e);
        }
        return request;
    }

    private void checkAuthState() {
        if (this.authentication == null) {
            throw new IllegalStateException("Missing API credentials");
        }
    }

    protected BrowserListing getBrowsersForProduct(Product product) throws BrowserStackException {
        return this.getBrowsersForProduct(product, true);
    }

    protected BrowserListing getBrowsersForProduct(Product product, boolean cache) throws BrowserStackException {
        BrowserListing browserListing;
        String productName = product.name().toLowerCase();
        String cacheKey = (CACHE_KEY_PREFIX_BROWSERS + productName).toLowerCase();
        if (cache && this.cacheMap.containsKey(cacheKey) && (browserListing = (BrowserListing)this.cacheMap.get(cacheKey)) != null) {
            return browserListing;
        }
        try {
            GenericUrl url = new GenericUrl("https://www.browserstack.com/list-of-browsers-and-platforms.json?product=" + productName);
            HttpResponse response = BrowserStackClient.newRequest(this.requestFactory, Method.GET, url).execute();
            browserListing = (BrowserListing)response.parseAs(BrowserListing.class);
        }
        catch (IOException e) {
            throw new BrowserStackException(e.getMessage(), 400);
        }
        if (cache) {
            this.cacheMap.put(cacheKey, browserListing);
        }
        return browserListing;
    }

    protected BrowserStackRequest newRequest(Method method, String path) throws BrowserStackException {
        return this.newRequest(method, path, true);
    }

    protected BrowserStackRequest newRequest(Method method, String path, boolean prependUrl) throws BrowserStackException {
        String urlPath = path == null ? "" : path;
        GenericUrl url = new GenericUrl(prependUrl ? this.baseUrl + urlPath : urlPath);
        return this.signRequest(BrowserStackClient.newRequest(this.requestFactory, method, url));
    }

    protected BrowserStackRequest newRequest(Method method, String path, Map<String, Object> data) throws BrowserStackException {
        return this.newRequest(method, path, data, null);
    }

    protected BrowserStackRequest newRequest(Method method, String path, Map<String, Object> data, Map<String, String> headers) throws BrowserStackException {
        BrowserStackRequest request = this.newRequest(method, path);
        if (headers != null && headers.size() > 0) {
            request.headers(headers);
        }
        if (data != null && data.size() > 0 && request.canContainBody()) {
            try {
                request.header("Content-Type", "application/json").body(JSON_MAPPER.writeValueAsString(data));
            }
            catch (JsonProcessingException e) {
                throw new BrowserStackException((Exception)((Object)e));
            }
        }
        return request;
    }

    protected BrowserStackRequest signRequest(HttpRequest request) throws BrowserStackException {
        this.checkAuthState();
        try {
            this.authentication.intercept(request);
        }
        catch (IOException e) {
            throw new BrowserStackException(e);
        }
        return new BrowserStackRequest(request);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Product {
        LIVE,
        AUTOMATE,
        SCREENSHOTS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

