import java.nio.file.Path
import java.nio.file.Paths

Properties requestProperties = request.properties
Path ymlFileGenerated = Paths.get(request.outputDirectory, 'browserstack_pre_generate.yml')
Path ymlFileOutput = Paths.get(request.outputDirectory, 'browserstack.yml')

def isCommented(String currentLine) {
  StringBuilder currentLineBuilder = new StringBuilder(currentLine);
  while (currentLineBuilder.length() > 0 && Character.isWhitespace(currentLineBuilder.charAt(0))) {
    currentLineBuilder.deleteCharAt(0);
  }
  if(currentLineBuilder.length() > 0 && currentLineBuilder.toString().substring(0,1).equals("#")) {
    return true
  } else {
    return false
  }
}

def isAppAutomate(Properties reqProperties) {
  return reqProperties.stringPropertyNames().contains("BROWSERSTACK_APP") && !reqProperties.getProperty("BROWSERSTACK_APP").toString().equals("BROWSERSTACK_APP") && !reqProperties.getProperty("BROWSERSTACK_APP").toString().equals("null")
}

def defaultBrowserstackYMLFile(Properties reqProperties){
  return "# =============================\n" +
          "# Set BrowserStack Credentials\n" +
          "# =============================\n" +
          "# Add your BrowserStack userName and accessKey here or set BROWSERSTACK_USERNAME and\n" +
          "# BROWSERSTACK_ACCESS_KEY as env variables\n" +
          "userName: "+reqProperties.getProperty("BROWSERSTACK_USERNAME")+"\n" +
          "accessKey: "+reqProperties.getProperty("BROWSERSTACK_ACCESS_KEY")+"\n" +
          "\n" +
          "# ======================\n" +
          "# BrowserStack Reporting\n" +
          "# ======================\n" +
          "# The following capabilities are used to set up reporting on BrowserStack:\n" +
          "# Set 'projectName' to the name of your project. Example, Marketing Website\n" +
          "projectName: "+reqProperties.getProperty("PROJECT_NAME")+"\n" +
          "# Set `buildName` as the name of the job / testsuite being run\n" +
          "buildName: "+reqProperties.getProperty("BUILD_NAME")+"\n" +
          "# `buildIdentifier` is a unique id to differentiate every execution that gets appended to\n" +
          "# buildName. Choose your buildIdentifier format from the available expressions:\n" +
          "# ${BUILD_NUMBER} (Default): Generates an incremental counter with every execution\n" +
          "# ${DATE_TIME}: Generates a Timestamp with every execution. Eg. 05-Nov-19:30\n" +
          "# Read more about buildIdentifiers here -> https://www.browserstack.com/docs/automate/selenium/organize-tests\n" +
          "buildIdentifier: '#${BUILD_NUMBER}' # Supports strings along with either/both ${expression}\n" +
          "\n" +
          "# =======================================\n" +
          "# Platforms (Browsers / Devices to test)\n" +
          "# =======================================\n" +
          "# Platforms object contains all the browser / device combinations you want to test on.\n" +
          "# Entire list available here -> (https://www.browserstack.com/list-of-browsers-and-platforms/automate)\n" +
          "platforms:\n" +
          "  - os: OS X\n" +
          "    osVersion: Big Sur\n" +
          "    browserName: Chrome\n" +
          "    browserVersion: latest\n" +
          "  - os: Windows\n" +
          "    osVersion: 10\n" +
          "    browserName: Edge\n" +
          "    browserVersion: latest\n" +
          "  - deviceName: Samsung Galaxy S22 Ultra\n" +
          "    browserName: chrome # Try 'samsung' for Samsung browser\n" +
          "    osVersion: 12.0\n" +
          "\n" +
          "source: java:archetype-integrate:v1.3\n" +
          "\n" +
          "# =======================\n" +
          "# Parallels per Platform\n" +
          "# =======================\n" +
          "# The number of parallel threads to be used for each platform set.\n" +
          "# BrowserStack's SDK runner will select the best strategy based on the configured value\n" +
          "#\n" +
          "# Example 1 - If you have configured 3 platforms and set `parallelsPerPlatform` as 2, a total of 6 (2 * 3) parallel threads will be used on BrowserStack\n" +
          "#\n" +
          "# Example 2 - If you have configured 1 platform and set `parallelsPerPlatform` as 5, a total of 5 (1 * 5) parallel threads will be used on BrowserStack\n" +
          "parallelsPerPlatform: 1\n" +
          "\n" +
          "# ==========================================\n" +
          "# BrowserStack Local\n" +
          "# (For localhost, staging/private websites)\n" +
          "# ==========================================\n" +
          "# Set browserStackLocal to true if your website under test is not accessible publicly over the internet\n" +
          "# Learn more about how BrowserStack Local works here -> https://www.browserstack.com/docs/automate/selenium/local-testing-introduction\n" +
          "browserstackLocal: true # <boolean> (Default false)\n" +
          "\n" +
          "# Options to be passed to BrowserStack local in-case of advanced configurations\n" +
          "# browserStackLocalOptions:\n" +
          "  # localIdentifier: # <string> (Default: null) Needed if you need to run multiple instances of local.\n" +
          "  # forceLocal: true  # <boolean> (Default: false) Set to true if you need to resolve all your traffic via BrowserStack Local tunnel.\n" +
          "  # Entire list of arguments available here -> https://www.browserstack.com/docs/automate/selenium/manage-incoming-connections\n" +
          "  \n" +
          "# ===================\n" +
          "# Debugging features\n" +
          "# ===================\n" +
          "debug: false # <boolean> # Set to true if you need screenshots for every selenium command ran\n" +
          "networkLogs: false # <boolean> Set to true to enable HAR logs capturing\n" +
          "consoleLogs: errors # <string> Remote browser's console debug levels to be printed (Default: errors)\n" +
          "# Available options are `disable`, `errors`, `warnings`, `info`, `verbose` (Default: errors)"
}

try {
  def defaultBrowserstackContent = new StringBuilder();
  def observabilityFileContent = new StringBuilder();
  Scanner scGenerated = new Scanner(ymlFileGenerated)
  String currentLine = ''
  boolean observabilityConfigStarted = false
  boolean appAutomateConfigStarted = false
  boolean appAutomateAndroidPlatformsStarted = false
  boolean appAutomateIOSPlatformsStarted = false
  boolean defaultPlatformsStarted = false
  while(scGenerated.hasNext()){
    currentLine = scGenerated.nextLine()
    if(currentLine.contains("OBSERVABILITY ONLY CONFIG")) {
      /* Dummy comment added to identify observability config from default browserstack config */
      observabilityConfigStarted = true
      continue
    }
    if(currentLine.contains("App Automate ONLY CONFIG Start")){
      /* Dummy comment added to identify app automate config from default browserstack config */
      appAutomateConfigStarted = true
      continue
    } else if(currentLine.contains("App Automate ONLY CONFIG End")){
      /* Dummy comment added to identify app automate config from default browserstack config */
      appAutomateConfigStarted = false
      continue
    } else if(currentLine.contains("Android Platforms Start")){
      /* Dummy comment added to identify app automate android config from default browserstack config */
      appAutomateAndroidPlatformsStarted = true
      continue
    } else if(currentLine.contains("Android Platforms End")){
      /* Dummy comment added to identify app automate android config from default browserstack config */
      appAutomateAndroidPlatformsStarted = false
      continue
    } else if(currentLine.contains("IOS Platforms Start")){
      /* Dummy comment added to identify app automate ios config from default browserstack config */
      appAutomateIOSPlatformsStarted = true
      continue
    } else if(currentLine.contains("IOS Platforms End")){
      /* Dummy comment added to identify app automate ios config from default browserstack config */
      appAutomateIOSPlatformsStarted = false
      continue
    } else if(currentLine.contains("Default Platforms Start")){
      /* Dummy comment added to identify app automate ios config from default browserstack config */
      defaultPlatformsStarted = true
      continue
    } else if(currentLine.contains("Default Platforms End")){
      /* Dummy comment added to identify app automate ios config from default browserstack config */
      defaultPlatformsStarted = false
      continue
    }
    if(observabilityConfigStarted) {
      /* Append contents for observability platform */
      if(currentLine.contains("buildName") && currentLine.contains("browserstack build")) {
        currentLine = "buildName: your unique build or job name goes here"
      }
      if(currentLine.contains("projectName") && currentLine.contains("BrowserStack Samples")) {
        currentLine = "projectName: your unique project name goes here"
      }
      if(currentLine.contains("source:")){
        currentLine = "source: java:obs-archetype-integrate:v1.3"
      }
      observabilityFileContent.append(currentLine).append("\n")
    } else if(appAutomateConfigStarted){
      /* Append contents for app automate config only */
      if(isAppAutomate(requestProperties)){
        defaultBrowserstackContent.append(currentLine).append("\n")
      }
    } else if(appAutomateAndroidPlatformsStarted){
      /* Append contents for app automate android config only */
      if(isAppAutomate(requestProperties) && requestProperties.stringPropertyNames().contains("BROWSERSTACK_PLATFORMS") && requestProperties.getProperty("BROWSERSTACK_PLATFORMS").toString().equals("ANDROID")){
        defaultBrowserstackContent.append(currentLine).append("\n")
      }
    } else if(appAutomateIOSPlatformsStarted){
      /* Append contents for app automate ios config only */
      if(isAppAutomate(requestProperties) && requestProperties.stringPropertyNames().contains("BROWSERSTACK_PLATFORMS") && requestProperties.getProperty("BROWSERSTACK_PLATFORMS").toString().equals("IOS")){
        defaultBrowserstackContent.append(currentLine).append("\n")
      }
    } else if(defaultPlatformsStarted){
      /* Append contents for default platforms only */
      if(!isAppAutomate(requestProperties)){
        defaultBrowserstackContent.append(currentLine).append("\n")
      }
    } else {
      /* Append contents for default config only */
      if(currentLine.contains("source:") && isAppAutomate(requestProperties)){
        currentLine = "source: java:appium-archetype-integrate:v1.3"
      } else if (currentLine.contains("source:")){
        currentLine = "source: java:archetype-integrate:v1.3"
      }
      defaultBrowserstackContent.append(currentLine).append("\n")
    }
  }

  File outputYMLFile = new File(ymlFileOutput.toString())
  if(outputYMLFile.exists()) {
    def overrideYMLFileContent = new StringBuilder();
    Scanner scOutput
    scOutput = new Scanner(ymlFileOutput)
    currentLine = ''
    boolean overrideUserNameFound = false
    boolean overrideAccessKeyFound = false
    boolean overrideProjectNameFound = false
    boolean overrideBuildNameFound = false
    boolean overrideTestObservabilityFound = false
    boolean overrideBrowserstackAutomationFound = false
    boolean overrideBrowserstackAppFound = false
    while(scOutput.hasNext()){
      currentLine = scOutput.nextLine()
      if(currentLine.length() && !isCommented(currentLine)) {
        if(currentLine.contains("userName:")) {
          currentLine = !requestProperties.getProperty("BROWSERSTACK_USERNAME").toString().equals("YOUR_USERNAME") ? "userName: " + requestProperties.getProperty("BROWSERSTACK_USERNAME").toString() : currentLine
          overrideUserNameFound = true
        } else if(currentLine.contains("accessKey:")) {
          currentLine = !requestProperties.getProperty("BROWSERSTACK_ACCESS_KEY").toString().equals("YOUR_ACCESS_KEY") ? "accessKey: " + requestProperties.getProperty("BROWSERSTACK_ACCESS_KEY").toString() : currentLine
          overrideAccessKeyFound = true
        } else if(currentLine.contains("projectName:")) {
          currentLine = !requestProperties.getProperty("PROJECT_NAME").toString().equals("BrowserStack Samples") && !requestProperties.getProperty("PROJECT_NAME").toString().equals("your unique project name goes here") ? "projectName: " + requestProperties.getProperty("PROJECT_NAME").toString() : currentLine
          overrideProjectNameFound = true
        } else if(currentLine.contains("buildName:")) {
          currentLine = !requestProperties.getProperty("BUILD_NAME").toString().equals("browserstack build") && !requestProperties.getProperty("BUILD_NAME").toString().equals("your unique build or job name goes here") ? "buildName: " + requestProperties.getProperty("BUILD_NAME").toString() : currentLine
          overrideBuildNameFound = true
        } else if(requestProperties.getProperty("TEST_OBSERVABILITY") != null && currentLine.contains("testObservability:")) {
          currentLine = "testObservability: " + requestProperties.getProperty("TEST_OBSERVABILITY").toString()
          overrideTestObservabilityFound = true
        } else if(currentLine.contains("browserstackAutomation:")) {
          currentLine = "browserstackAutomation: " + requestProperties.getProperty("BROWSERSTACK_AUTOMATION").toString()
          overrideBrowserstackAutomationFound = true
        } else if(currentLine.contains("app:")) {
          currentLine = !requestProperties.getProperty("BROWSERSTACK_APP").toString().equals("BROWSERSTACK_APP") ? "app: " + requestProperties.getProperty("BROWSERSTACK_APP").toString() : currentLine
          overrideBrowserstackAppFound = true
        }
      }
      overrideYMLFileContent.append(currentLine).append("\n")
    }

    if(!overrideUserNameFound && !requestProperties.getProperty("BROWSERSTACK_USERNAME").toString().equals("YOUR_USERNAME")) {
      overrideYMLFileContent.append("\n")
      overrideYMLFileContent.append("userName: " + requestProperties.getProperty("BROWSERSTACK_USERNAME").toString()).append("\n")
    }
    if(!overrideAccessKeyFound && !requestProperties.getProperty("BROWSERSTACK_ACCESS_KEY").toString().equals("YOUR_ACCESS_KEY")) {
      overrideYMLFileContent.append("\n")
      overrideYMLFileContent.append("accessKey: " + requestProperties.getProperty("BROWSERSTACK_ACCESS_KEY").toString()).append("\n")
    }
    if(!overrideProjectNameFound && !requestProperties.getProperty("PROJECT_NAME").toString().equals("BrowserStack Samples") && !requestProperties.getProperty("PROJECT_NAME").toString().equals("your unique project name goes here")) {
      overrideYMLFileContent.append("\n")
      overrideYMLFileContent.append("# Set 'projectName' to the name of your project. Example, Marketing Website").append("\n")
      overrideYMLFileContent.append("projectName: " + requestProperties.getProperty("PROJECT_NAME").toString()).append("\n")
    }
    if(!overrideBuildNameFound && !requestProperties.getProperty("BUILD_NAME").toString().equals("browserstack build") && !requestProperties.getProperty("BUILD_NAME").toString().equals("your unique build or job name goes here")) {
      overrideYMLFileContent.append("\n")
      overrideYMLFileContent.append("# Set `buildName` as the name of the job / testsuite being run").append("\n")
      overrideYMLFileContent.append("buildName: " + requestProperties.getProperty("BUILD_NAME").toString()).append("\n")
    }
    if(!overrideTestObservabilityFound && requestProperties.getProperty("TEST_OBSERVABILITY") != null && requestProperties.getProperty("TEST_OBSERVABILITY").toString().equals("false")) {
      overrideYMLFileContent.append("\n")
      overrideYMLFileContent.append("# =======================").append("\n")
      overrideYMLFileContent.append("# Test Observability").append("\n")
      overrideYMLFileContent.append("# =======================").append("\n")
      overrideYMLFileContent.append("# This flag turns data reporting to Browserstack Test Observability on/off").append("\n")
      overrideYMLFileContent.append("testObservability: " + requestProperties.getProperty("TEST_OBSERVABILITY").toString()).append("\n")
    }
    if(!overrideBrowserstackAutomationFound && requestProperties.getProperty("BROWSERSTACK_AUTOMATION").toString().equals("false")) {
      overrideYMLFileContent.append("\n")
      overrideYMLFileContent.append("# =======================").append("\n")
      overrideYMLFileContent.append("# Browserstack Automation").append("\n")
      overrideYMLFileContent.append("# =======================").append("\n")
      overrideYMLFileContent.append("# This flag decides whether to run your test suite on Browserstack platform or not").append("\n")
      overrideYMLFileContent.append("browserstackAutomation: " + requestProperties.getProperty("BROWSERSTACK_AUTOMATION").toString()).append("\n")
    }
    if(!overrideBrowserstackAppFound && !requestProperties.getProperty("BROWSERSTACK_APP").toString().equals("BROWSERSTACK_APP")) {
      overrideYMLFileContent.append("# =======================================").append("\n")
      overrideYMLFileContent.append("# App").append("\n")
      overrideYMLFileContent.append("# =======================================").append("\n")
      overrideYMLFileContent.append("# Set `app` to use the appliction under test for Appium sessions.").append("\n")
      overrideYMLFileContent.append("# Available options:").append("\n")
      overrideYMLFileContent.append("# app: '/path/to/local/app.apk'").append("\n")
      overrideYMLFileContent.append("# OR").append("\n")
      overrideYMLFileContent.append("# app: 'bs://<app-id>' # App URL returned when uploading the app to BrowserStack manually").append("\n")
      overrideYMLFileContent.append("# Visit https://www.browserstack.com/docs/app-automate/appium/set-up-tests/specify-app for more options").append("\n")
      overrideYMLFileContent.append("app: " + requestProperties.getProperty("BROWSERSTACK_APP").toString()).append("\n")
    }

    PrintWriter writer = new PrintWriter(ymlFileOutput.toFile())
    /* Override contents of browserstack.yml */
    writer.write(overrideYMLFileContent.toString())
    writer.close()
  } else {
    if(requestProperties.getProperty("BROWSERSTACK_AUTOMATION") != null
            && !requestProperties.getProperty("BROWSERSTACK_AUTOMATION").toString().equals("null")
            && requestProperties.getProperty("BROWSERSTACK_AUTOMATION").toString().equals("false")
    ) {
      PrintWriter writer = new PrintWriter(ymlFileOutput.toFile())
      /* Replace contents of browserstack.yml */
      writer.write(observabilityFileContent.toString())
      writer.close()
    } else {
      PrintWriter writer = new PrintWriter(ymlFileOutput.toFile())
      /* Replace contents of browserstack.yml */
      writer.write(defaultBrowserstackContent.toString())
      writer.close()
    }
  }
} catch(Throwable e) {
  PrintWriter writer = new PrintWriter(ymlFileOutput.toFile())
  /* Replace default contents of browserstack.yml */
  writer.write(defaultBrowserstackYMLFile(requestProperties).toString())
  writer.close()
  e.printStackTrace()
} finally {
  new File(ymlFileGenerated.toString()).delete()
}
