package com.btjava.common.utils.encode;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * md5加密工具
 */
public class Md5Util {
    /**
     * MD5加密
     * @param plainText 明文密码
     * @return
     */
    public static String md5Encode(String plainText) {
        byte[] secretBytes = null;
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(
                    plainText.getBytes("UTF-8"));
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("没有这个md5算法！");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String md5code = new BigInteger(1, secretBytes).toString(16);
        for (int i = 0; i < 32 - md5code.length(); i++) {
            md5code = "0" + md5code;
        }
        return md5code;
    }

    /**
     * 密码加密
     * @param pwd 明文密码
     * @param userMap 用户对象
     * @return 密码密文
     * @throws ParseException
     */
    public static String encodePwd(String pwd, Map<String,Object> userMap) throws ParseException{
        return encodePwd(pwd,userMap.get("userId").toString().trim(),new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(userMap.get("regTime").toString().trim()));
    }
    /**
     * 密码加密
     * @param pwd 明文密码
     * @param uid uid
     * @param date 时间
     * @return 密码密文
     */
    public static String encodePwd(String pwd, String uid, Date date){
        //MD5加密
        pwd =md5Encode(pwd);
        //根据时间最后五位和UID进行替换
        Long time = date.getTime()/1000;
        int lastNum = Integer.parseInt((time%100000)+"");
        pwd =removeChar(pwd,lastNum);
        pwd =addChar(pwd,uid,lastNum);
        pwd=md5Encode(pwd);
        return pwd;
    }

    /**
     * 删除指定字符
     * @param s 字符串
     * @param num 指定位置
     * @return
     */
    private static String removeChar(String s,int num){
        if(num !=0){
            int n= (num%10)+1;
            s=s.substring(0,n-1) +s.substring(n);
            num = num/10;
            s=removeChar(s,num);
        }
        return s;
    }

    /**
     * 为s1混入s2的指定字符串
     * @param s1 原始字符串
     * @param s2 混入串
     * @param num 指定位置
     * @return
     */
    private static String addChar(String s1,String s2,int num){
        if(num !=0){
            int n= (num%10);
            s1=s1.substring(0,n)+s2.charAt(n)+s1.substring(n);
            num = num/10;
            s1=addChar(s1,s2,num);
        }
        return s1;
    }
}
