package com.btjava.common.utils.encode;

import org.apache.commons.lang.StringUtils;

/**
 * 常见文本打码工具
 */
public class TextMaskUtils {
    /**
     * 手机号码加密
     * @param tel 手机号码
     * @return 加密后的手机号码
     */
    public static String hideTel(String tel){
        if(!StringUtils.isEmpty(tel)){
            return  strMask(tel,3,4);
        }
        return null;
    }
    /**
     * 座机号码加密
     * @param tel 座机号码
     * @return 加密后的座机号码
     */
    public static String hideLandline(String tel){
        if(!StringUtils.isEmpty(tel)){
            if(tel.indexOf("-")>=0){
                String fristMoble = tel.substring(0,tel.indexOf("-")+1);
                String lastMoble = tel.substring(tel.indexOf("-")+5);
                return fristMoble + "****" +lastMoble;
            }else{
                if(tel.length()>=9){
                    StringBuilder telBuilder=new StringBuilder();
                    int countYz=0;
                    for(int i=0;i<tel.length();i++){
                        if(countYz<4&&i>2){
                            countYz++;
                            telBuilder.append("*");
                        }else{
                            telBuilder.append(tel.charAt(i));
                        }
                    }
                    return  telBuilder.toString();
                }else{
                    StringBuilder telBuilder=new StringBuilder();
                    int countYz=0;
                    for(int i=0;i<tel.length();i++){
                        if(countYz<4&&i>0){
                            countYz++;
                            telBuilder.append("*");
                        }else{
                            telBuilder.append(tel.charAt(i));
                        }
                    }
                    return  telBuilder.toString();
                }
            }
        }
        return null;
    }
    /**
     * 身份证号码加密
     * @param idcard 身份证号码
     * @return 加密后的身份证号码
     */
    public static String hideIdcard(String idcard){
        if(!StringUtils.isEmpty(idcard)){
            return strMask(idcard,4,4);
        }
        return null;
    }
    /**
     * QQ号码加密
     * @param QQNum QQ号码
     * @return 加密后的QQ号码
     */
    public static String hideQQNum(String QQNum){
        if(!StringUtils.isEmpty(QQNum)){
            return strMask(QQNum,1,2);
        }
        return null;
    }

    /**
     * 微信号码加密
     * @param wecharNo 微信号码
     * @return 加密后的微信号码
     * 当前加密方式与QQ相同，为了以后好改，拆分成两个方法
     */
    public static String hideWecharNo(String wecharNo){
        if(!StringUtils.isEmpty(wecharNo)){
            return strMask(wecharNo,1,2);
        }
        return null;
    }
    /**
     * 邮箱地址加密
     * @param email 邮箱地址
     * @return 加密后的邮箱地址
     */
    public static String hideEmail(String email){
        if(!StringUtils.isEmpty(email)){
            if(email.indexOf("@")>0){
                String name =email.substring(0,email.indexOf("@"));
                if(name.length()>4){
                    name =strMask(name,name.length()-4,0);
                }else{
                    name =strMask(name,name.length()-2>=1?name.length()-2:1,2,1);
                }
                return name+email.substring(email.indexOf("@"));
            }else{
                return null;
            }
        }
        return null;
    }
    /**
     * 银行卡账号加密
     * @param bankCardNo 银行卡账号
     * @return 加密后的银行卡账号
     */
    public static String hideBankCardNo(String bankCardNo){
        if(!StringUtils.isEmpty(bankCardNo)){
            return strMask(bankCardNo,0,4);
        }
        return null;
    }

    /**
     * 字符串加密
     * @param str 需要加密的字符串
     * @param front 头部显示的字符串长度
     * @param end 尾部需要显示的字符串长度
     * @return 加密后的银行卡账号
     */
    public static String strMask(String str, int front, int end) {
        //需要加密的字符串不能为空
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        //需要截取的长度不能大于字符串长度
        if ((front + end) > str.length()) {
            return null;
        }
        //需要截取的不能小于0
        if (front < 0 || end < 0) {
            return null;
        }
        //计算*的数量
        int asteriskCount = str.length() - (front + end);
        StringBuffer asteriskStr = new StringBuffer();
        for (int i = 0; i < asteriskCount; i++) {
            asteriskStr.append("*");
        }
        String regex = "(\\w{" + String.valueOf(front) + "})(\\w+)(\\w{" + String.valueOf(end) + "})";
        return str.replaceAll(regex, "$1" + asteriskStr + "$3");
    }
    /**
     * 对字符串进行指定长度的加密
     * @param str 需要加密的字符串
     * @param front 头部显示的字符串长度
     * @param hideLength 加密的长度
     * @param type 1-如果str长度不够,尾部追加差数的*，0-不追加
     * @return 已经加密的字符串
     */
    public static String strMask(String str, int front, int hideLength, int type) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        int length = str.length();
        int end = length -front -hideLength;
        if(end<0){
            if(type==1){
                StringBuffer sb = new StringBuffer(str);
                int subLen = end * -1;
                while(subLen>0){
                    sb.append("0");
                    subLen =subLen-1;
                }
                str = sb.toString();
            }
            end=0;
        }
        return strMask(str,front,end);
    }
    /**
     * 对字符串进行指定长度的加密
     * @param str 需要加密的字符串
     * @param hideLength 加密的长度
     * @return 已经加密的字符串
     * 如果str的长度减去hideLength是单数，则尾部显示字符长度尾头部显示字符长度加1，否则两边显示长度相等
     */
    public static String strMask(String str, int hideLength) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        int length = str.length();
        int front= (length-hideLength)/2;
        int end=0;
        if((length-hideLength)%2==1){
            end= front+1;
        }else{
            end = front;
        }
        return strMask(str,front,end);
    }
}
