package com.btjava.common.utils.enums;

import org.apache.commons.lang3.StringUtils;

public enum DateEnum {
    FULL_YEAR("full_year","年"),
    FULL_MONTH("full_month","月"),
    FULL_DAY("full_day","日"),
    HOUR("hour","时"),
    FULL_HOUR("full_hour","时"),
    MINUTE("minute","分"),
    FULL_MINUTE("full_minute","分"),
    SECOND("second","秒"),
    FULL_SECOND("full_second","秒");
    private String code;
    private String desc;
    DateEnum(String code,String desc){
        this.code =code;
        this.desc =desc;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }
    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据编码获取描述
     * @param code 编码
     * @return 描述
     */
    public static String getDecByCode(String code){
        if(!StringUtils.isNotBlank(code)){
            return null;
        }
        DateEnum[] arr =DateEnum.values();
        for(DateEnum de :arr){
            if(code.equals(de.getCode())){
                return de.getDesc();
            }
        }
        return null;
    }
}
