package com.btjava.common.utils.office.excel.pojo;

import com.btjava.common.utils.text.pojo.CallMethod;

public class ColCallMethod extends CallMethod {

    public ColCallMethod() {
    }

    /**
     * @param className 类名(全路径)
     * @param methodName 方法名称
     * @param colIndexNum excel值在方法中的位置,0开始计数 例：f(a,b,c) 如果b是excel对象的值,colIndexNum =1
     */
    public ColCallMethod(String className, String methodName, Integer colIndexNum) {

        super(className, methodName,null);
        this.colIndexNum = colIndexNum;
    }
    /**
     * @param className 类名(全路径)
     * @param methodName 方法名称
     * @param params 参数列表
     * @param colIndexNum excel值在方法中的位置,0开始计数 例：f(a,b,c) 如果b是excel对象的值,colIndexNum =1
     */
    public ColCallMethod(String className, String methodName, Object[] params, Integer colIndexNum) {
        super(className, methodName, params);
        this.colIndexNum = colIndexNum;
    }
    /**
     * @param className 类名(全路径)
     * @param methodName 方法名称
     * @param paramTypes 参数类型列表，如果参数中可能出现空值，则需要传入参数列表。否则无法进行格式化
     * @param params 参数列表
     * @param colIndexNum excel值在方法中的位置,0开始计数 例：f(a,b,c) 如果b是excel对象的值,colIndexNum =1
     */
    public ColCallMethod(String className, String methodName, Class[] paramTypes, Object[] params, Integer colIndexNum) {
        super(className, methodName, paramTypes, params);
        this.colIndexNum = colIndexNum;
    }
    /**
     * excel数据所在参数中的位置，第一个位置为0
     */
    private Integer colIndexNum;

    public Integer getColIndexNum() {
        return colIndexNum;
    }

    public void setColIndexNum(Integer colIndexNum) {
        this.colIndexNum = colIndexNum;
    }

    @Override
    public String toString() {
        return "ColCallMethod{" +
                "colIndexNum=" + colIndexNum +
                '}';
    }
}
