package com.btjava.common.utils.office.excel.pojo;

import org.apache.poi.ss.usermodel.CellStyle;

import java.util.HashMap;
import java.util.Map;

public class ExcelCol {
    /**
     * 当前列默认样式,优先级最低
     */
    public static final String STYLE_KEY_All="all";
    /**
     * 当前列表头样式 优先级中(仅用于表头)
     */
    public static final String STYLE_KEY_ONLY_TITLE="only_title";
    /**
     * 当前列数据样式 优先级中 (仅用于数据)
     */
    public static final String STYLE_KEY_ONLY_DATA="only_data";
    /**
     * 当前列数据满足特定条件时的样式 优先级最高
     */
    public static final String STYLE_KEY_ONLY_CONDITION="only_condition";
    /**
     * 属性(对象属性)
     */
    private String field;
    /**
     * 表头
     */
    private String titile;
    /**
     * 样式
     */
    private Map<String,CellStyle> cellStyleMap;
    /**
     * 列宽
     */
    private Integer columnWidth;
    /**
     * 处理值得函数对象
     */
    private ColCallMethod  colCallMethod;

    public ExcelCol(){}

    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     */
    public ExcelCol(String field, String titile){
        this.field = field;
        this.titile =titile;
    }
    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     * @param columnWidth 列宽
     */
    public ExcelCol(String field, String titile, Integer columnWidth) {
        this.field = field;
        this.titile = titile;
        this.columnWidth = columnWidth;
    }
    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     * @param colCallMethod 数据格式化函数对象
     */
    public ExcelCol(String field, String titile, ColCallMethod colCallMethod) {
        this.field = field;
        this.titile = titile;
        this.colCallMethod = colCallMethod;
    }

    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     * @param colCallMethod 数据格式化函数对象
     * @param columnWidth 列宽
     */
    public ExcelCol(String field, String titile, ColCallMethod colCallMethod ,Integer columnWidth) {
        this.field = field;
        this.titile = titile;
        this.columnWidth = columnWidth;
        this.colCallMethod = colCallMethod;
    }
    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     * @param cellStyleMap 样式
     */
    public ExcelCol(String field, String titile, Map<String,CellStyle> cellStyleMap) {
        this.field = field;
        this.titile = titile;
        this.cellStyleMap = cellStyleMap;
    }
    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     * @param cellStyleMap 样式
     * @param colCallMethod 数据格式化函数对象
     */
    public ExcelCol(String field, String titile, Map<String,CellStyle> cellStyleMap, ColCallMethod colCallMethod) {
        this.field = field;
        this.titile = titile;
        this.cellStyleMap = cellStyleMap;
        this.colCallMethod = colCallMethod;
    }
    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     * @param cellStyleMap 样式
     * @param columnWidth 列宽
     */
    public ExcelCol(String field, String titile, Map<String,CellStyle> cellStyleMap, Integer columnWidth) {
        this.field = field;
        this.titile = titile;
        this.cellStyleMap = cellStyleMap;
        this.columnWidth = columnWidth;
    }
    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     * @param cellStyleMap 样式
     * @param columnWidth 列宽
     * @param colCallMethod 数据格式化函数对象
     */
    public ExcelCol(String field, String titile, Map<String,CellStyle> cellStyleMap, Integer columnWidth, ColCallMethod colCallMethod) {
        this.field = field;
        this.titile = titile;
        this.cellStyleMap = cellStyleMap;
        this.columnWidth = columnWidth;
        this.colCallMethod = colCallMethod;
    }
    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     * @param cellStyle 表头样式
     */
    public ExcelCol(String field, String titile, CellStyle cellStyle) {
        this.field = field;
        this.titile = titile;
        Map<String,CellStyle> cellStyleMap = new HashMap<String,CellStyle>();
        cellStyleMap.put(STYLE_KEY_ONLY_TITLE,cellStyle);
        this.cellStyleMap = cellStyleMap;
    }
    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     * @param cellStyle 表头样式
     * @param colCallMethod 数据格式化函数对象
     */
    public ExcelCol(String field, String titile, CellStyle cellStyle, ColCallMethod colCallMethod) {
        this.field = field;
        this.titile = titile;
        Map<String,CellStyle> cellStyleMap = new HashMap<String,CellStyle>();
        cellStyleMap.put(STYLE_KEY_ONLY_TITLE,cellStyle);
        this.cellStyleMap = cellStyleMap;
        this.colCallMethod = colCallMethod;
    }
    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     * @param cellStyle 表头样式
     * @param columnWidth 列宽
     */
    public ExcelCol(String field, String titile, CellStyle cellStyle, Integer columnWidth) {
        this.field = field;
        this.titile = titile;
        Map<String,CellStyle> cellStyleMap = new HashMap<String,CellStyle>();
        cellStyleMap.put(STYLE_KEY_ONLY_TITLE,cellStyle);
        this.cellStyleMap = cellStyleMap;
        this.columnWidth = columnWidth;
    }
    /**
     * @param field 对象的属性名
     * @param titile Excel中的表头
     * @param cellStyle 表头样式
     * @param columnWidth 列宽
     * @param colCallMethod 数据格式化函数对象
     */
    public ExcelCol(String field, String titile, CellStyle cellStyle, Integer columnWidth, ColCallMethod colCallMethod) {
        this.field = field;
        this.titile = titile;
        Map<String,CellStyle> cellStyleMap = new HashMap<String,CellStyle>();
        cellStyleMap.put(STYLE_KEY_ONLY_TITLE,cellStyle);
        this.cellStyleMap = cellStyleMap;
        this.columnWidth = columnWidth;
        this.colCallMethod = colCallMethod;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getTitile() {
        return titile;
    }

    public void setTitile(String titile) {
        this.titile = titile;
    }

    public Map<String, CellStyle> getCellStyleMap() {
        return cellStyleMap;
    }

    public void setCellStyleMap(Map<String, CellStyle> cellStyleMap) {
        this.cellStyleMap = cellStyleMap;
    }

    public Integer getColumnWidth() {
        return columnWidth;
    }

    public void setColumnWidth(Integer columnWidth) {
        this.columnWidth = columnWidth;
    }

    public ColCallMethod getColCallMethod() {
        return colCallMethod;
    }

    public void setColCallMethod(ColCallMethod colCallMethod) {
        this.colCallMethod = colCallMethod;
    }
    @Override
    public String toString() {
        return "ExcelCol{" +
                "field='" + field + '\'' +
                ", titile='" + titile + '\'' +
                ", cellStyleMap=" + cellStyleMap +
                ", columnWidth=" + columnWidth +
                '}';
    }
}
