package com.btjava.common.utils.office.excel.pojo;

import java.util.Objects;

public class ExcelData {
    /**
     * 样式标记，true将优先加载 ExcelCol 中的 STYLE_KEY_ONLY_CONDITION 样式
     */
    private Boolean styleFlag;
    /**
     * 数据对象
     */
    private Object data;

    public ExcelData() {}
    /**
     * @param data 数据对象
     */
    public ExcelData(Object data) {
        this.data = data;
        this.styleFlag =false;
    }

    /**
     * @param data 数据对象
     * @param styleFlag 样式标记，true将优先加载 ExcelCol 中的 STYLE_KEY_ONLY_CONDITION 样式
     */
    public ExcelData(Object data,Boolean styleFlag) {
        this.data = data;
        this.styleFlag = Objects.isNull(styleFlag)?false:styleFlag ;
    }

    public Boolean getStyleFlag() {
        return styleFlag;
    }

    public void setStyleFlag(Boolean styleFlag) {
        this.styleFlag = styleFlag;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "ExcelData{" +
                "styleFlag=" + styleFlag +
                ", data=" + data +
                '}';
    }
}
