package com.btjava.common.utils.text;

import com.btjava.common.utils.text.pojo.CallMethod;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;

public class DataTools
{
    /**
     * 生成UUID
     * @return
     */
    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }
    /**
     * 获取Map中的值，返回NULL或非空字符串
     * @param paramMap
     * @param attr
     * @return
     */
    public static String getAttrByName(Map<String,Object> paramMap , String attr){
        String str =paramMap.containsKey(attr)&& paramMap.get(attr) !=null && !"".equals(paramMap.get(attr).toString().trim())
                ? paramMap.get(attr).toString().trim() :null;
        return str;
    }

    /**
     * 从map中获取指定对象
     * @param paramMap
     * @param key
     * @return
     */
    public static Object getObjByMap(Map<String,Object> paramMap,String key){
        return paramMap.containsKey(key) && paramMap.get(key) !=null
                && !"".equals(paramMap.get(key))? paramMap.get(key):null;
    }
    /**
     * 把一个存放Map的List，按照指定的key的值为行Map的key转换成Map。
     * 如果指定value,就使用value所取出的值为value，则使用key所在Map为value.
     * 		(使用该方法时，请保证key和value一定存在于每个Map中)
     * @param list
     * @param key
     * @param value
     * @return
     */
    public static Map<String,Object> ListToMap(List<Map<String,Object>> list, String key, String value){
        Map<String,Object> map = new HashMap<String,Object>();
        boolean flag =true;
        if(value ==null || "".equals(value.trim())){
            flag =false;
        }
        for(Map<String,Object> m:list){
            if(flag){
                if(m.containsKey(key)){
                    if(m.containsKey(value)){
                        map.put(m.get(key).toString(),m.get(value));
                    }else{
                        map.put(m.get(key).toString(),null);
                    }
                }
            }else{
                if(m.containsKey(key)){
                    map.put(m.get(key).toString(),m);
                }
            }
        }
        return map;
    }

    /**
     * 对象转成map
     * @param obj 要转换的对象
     * @return
     * @throws Exception
     */
    public static Map<String, Object> objectToMap(Object obj) throws Exception {
        if(obj == null){
            return null;
        }
        Map<String, Object> map = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (PropertyDescriptor property : propertyDescriptors) {
            String key = property.getName();
            if (key.compareToIgnoreCase("class") == 0) {
                continue;
            }
            Method getter = property.getReadMethod();
            Object value = getter!=null ? getter.invoke(obj) : null;
            map.put(key, value);
        }
        return map;
    }

    /**
     * 获取随机数
     * @param max 最大范围
     * @return
     */
    public static int getRandomInt(int max){
        Random random = new Random();
        return random.nextInt(max);
    }

    /**
     * 通过字符串串调用方法
     * @param className 类名 全路径
     * @param methodName 方法名，通过此字符串调用类中的方法
     * @param params 需要调用的方法的参数列表
     * @return
     */
    public static Object callMethod(String className ,String methodName,Object[] params)
    {
        Class [] paramTypes =new Class[Objects.isNull(params)?0:params.length];
        if(!Objects.isNull(params)){
            for(int i =0;i<params.length;i++){
                paramTypes[i]=params[i].getClass();
            }
        }
        return callMethod(className,methodName,paramTypes,params);
    }

    /**
     * 通过字符串串调用方法
     * @param className 类名 全路径
     * @param methodName 方法名，通过此字符串调用类中的方法
     * @param paramList 需要调用的方法的参数列表
     * @return
     */
    public static Object callMethod(String className ,String methodName,List<Object> paramList)
    {
        Class [] paramTypes =new Class[Objects.isNull(paramList)?0:paramList.size()];
        Object [] params =new Object[Objects.isNull(paramList)?0:paramList.size()];
        if(!Objects.isNull(paramList)){
            for(int i =0;i<paramList.size();i++){
                paramTypes[i]=paramList.get(i).getClass();
                params[i] =paramList.get(i);
            }
        }
        return callMethod(className,methodName,paramTypes,params);
    }
    /**
     * 通过字符串串调用方法
     * @param className 类名 全路径
     * @param methodName 方法名，通过此字符串调用类中的方法
     * @param paramTypes 需要调用的方法的参数类型列表
     * @param params 需要调用的方法的参数列表
     * @return
     */
    public static Object callMethod(String className ,String methodName,Class[] paramTypes,Object[] params){
        try {
            //加载类，参数是完整类名
            Class clazz = Class.forName(className);
            //第一个参数是方法名，后面的参数指示方法的参数类型和个数
            Method method = clazz.getMethod(methodName, paramTypes);
            //accessiable设为true表示忽略java语言访问检查（可访问private方法）
            method.setAccessible(true);
            //第一个参数类实例(必须有对象才能调用非静态方法,如果是静态方法此参数可为null)
            //第二个是要传给方法的参数
            Object result = method.invoke(clazz.newInstance(), params);
            return result;
            //这里为了博客上简洁一些把其他catch都去掉了(复制代码的同学应该把其他异常的catch搞出来)
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (NoSuchMethodException e){
            e.printStackTrace();
        } catch (InstantiationException e){
            e.printStackTrace();
        } catch (IllegalAccessException e){
            e.printStackTrace();
        } catch (InvocationTargetException e){
            e.printStackTrace();
        } catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }
    /**
     * 通过字符串串调用方法
     * @param callMethod 封装好的方法对象
     * @return
     */
    public static Object callMethod(CallMethod callMethod){
        if(Objects.isNull(callMethod.getParamTypes())){
            return callMethod(callMethod.getClassName(),callMethod.getMethodName(),callMethod.getParams());
        }else{
            return callMethod(callMethod.getClassName(),callMethod.getMethodName(),callMethod.getParamTypes(),callMethod.getParams());
        }
    }
}
