package com.btjava.common.utils.wx;

import com.btjava.common.utils.text.HTTPTools;
import net.sf.json.JSONObject;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.Objects;

public class WXConnect {
    /**
     * 获取授权code地址
     * 0-appid 1-appsecret 2-code
     */
    public static String GET_ACCESS_TOKEN_URL ="https://api.weixin.qq.com/sns/oauth2/access_token?appid={0}&secret={1}&code={2}&grant_type=authorization_code";
    /**
     * 刷新授权code地址
     * 0-appid 1-refresh_token
     */
    public static String REFRESH_TOKEN_URL ="https://api.weixin.qq.com/sns/oauth2/refresh_token?appid={0}&grant_type=refresh_token&refresh_token={1}";
    /**
     * 获取用户信息地址
     * 0-access_token 1-openid
     */
    public static String GET_USER_INFO_URL ="https://api.weixin.qq.com/sns/userinfo?access_token={0}&openid={1}&lang=zh_CN";
    /**
     * 检查授权是否有效
     * 0-access_toke 1-openid
     */
    public static String CHECK_OAUTH_URL ="https://api.weixin.qq.com/sns/auth?access_token={0}&openid={1}";

    /**
     * 远程请求数据
     * @param url 请求地址
     */
    public static JSONObject getRemoteInfo(String url){
        try {
            /**
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet request = new HttpGet(url);
            HttpResponse response = client.execute(request);
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                String strResult = EntityUtils.toString(response.getEntity(),"utf-8");
                JSONObject jsonResult = JSONObject.fromObject(strResult);
                return jsonResult;
            } else {
                System.out.println("error");
            }
             */
            String strResult = HTTPTools.post(url,"",HTTPTools.HTTP_CHARSET);
            JSONObject jsonResult = JSONObject.fromObject(strResult);
            return jsonResult;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * url参数转换
     * @param url 地址，包含{n}
     * @param param 放入地址的参数
     */
    public static String urlConvert(String url,String ...param){
        if(!Objects.isNull(param) && param.length>0){
            for(int i=0;i<param.length;i++){
                url = url.replace("{"+i+"}",param[i]);
            }
        }
        return url;
    }
}
