/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.escloud.model;

import com.byteplus.escloud.model.TagFilterForListTagsForResourcesInput;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;

public class ListTagsForResourcesRequest {
    @SerializedName(value="PageNumber")
    private Integer pageNumber = null;
    @SerializedName(value="PageSize")
    private Integer pageSize = null;
    @SerializedName(value="ResourceIds")
    private List<String> resourceIds = null;
    @SerializedName(value="ResourceType")
    private ResourceTypeEnum resourceType = null;
    @SerializedName(value="TagFilters")
    private List<TagFilterForListTagsForResourcesInput> tagFilters = null;

    public ListTagsForResourcesRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Min(value=1L)
    @Schema(description="")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public ListTagsForResourcesRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Schema(description="")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public ListTagsForResourcesRequest resourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
        return this;
    }

    public ListTagsForResourcesRequest addResourceIdsItem(String resourceIdsItem) {
        if (this.resourceIds == null) {
            this.resourceIds = new ArrayList<String>();
        }
        this.resourceIds.add(resourceIdsItem);
        return this;
    }

    @Schema(description="")
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(List<String> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public ListTagsForResourcesRequest resourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Schema(description="")
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public ListTagsForResourcesRequest tagFilters(List<TagFilterForListTagsForResourcesInput> tagFilters) {
        this.tagFilters = tagFilters;
        return this;
    }

    public ListTagsForResourcesRequest addTagFiltersItem(TagFilterForListTagsForResourcesInput tagFiltersItem) {
        if (this.tagFilters == null) {
            this.tagFilters = new ArrayList<TagFilterForListTagsForResourcesInput>();
        }
        this.tagFilters.add(tagFiltersItem);
        return this;
    }

    @Valid
    @Schema(description="")
    public List<TagFilterForListTagsForResourcesInput> getTagFilters() {
        return this.tagFilters;
    }

    public void setTagFilters(List<TagFilterForListTagsForResourcesInput> tagFilters) {
        this.tagFilters = tagFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTagsForResourcesRequest listTagsForResourcesRequest = (ListTagsForResourcesRequest)o;
        return Objects.equals(this.pageNumber, listTagsForResourcesRequest.pageNumber) && Objects.equals(this.pageSize, listTagsForResourcesRequest.pageSize) && Objects.equals(this.resourceIds, listTagsForResourcesRequest.resourceIds) && Objects.equals((Object)this.resourceType, (Object)listTagsForResourcesRequest.resourceType) && Objects.equals(this.tagFilters, listTagsForResourcesRequest.tagFilters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pageNumber, this.pageSize, this.resourceIds, this.resourceType, this.tagFilters});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTagsForResourcesRequest {\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    resourceIds: ").append(this.toIndentedString(this.resourceIds)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    tagFilters: ").append(this.toIndentedString(this.tagFilters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResourceTypeEnum {
        INSTANCE("instance");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResourceTypeEnum fromValue(String input) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ResourceTypeEnum> {
            public void write(JsonWriter jsonWriter, ResourceTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ResourceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResourceTypeEnum.fromValue(value);
            }
        }
    }
}

