/*
 * Decompiled with CFR 0.152.
 */
package byteplus.rec.sdk.retail;

import byteplus.rec.core.BizException;
import byteplus.rec.core.HTTPClient;
import byteplus.rec.core.NetException;
import byteplus.rec.core.Option;
import byteplus.rec.sdk.retail.RetailClient;
import byteplus.rec.sdk.retail.protocol.ByteplusSaasRetail;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetailClientImpl
implements RetailClient {
    private static final Logger log = LoggerFactory.getLogger(RetailClientImpl.class);
    private static final String ERR_MSG_TOO_MANY_WRITE_ITEMS = String.format("Only can receive max to %d items in one write request", 2000);
    private HTTPClient httpClient;

    protected RetailClientImpl(HTTPClient httpClient) {
        this.httpClient = httpClient;
    }

    private boolean noneEmptySting(String str) {
        return str != null && str.length() != 0;
    }

    @Override
    public ByteplusSaasRetail.WriteResponse writeUsers(ByteplusSaasRetail.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        return this.doWriteData(request, "/RetailSaaS/WriteUsers", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse writeProducts(ByteplusSaasRetail.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        return this.doWriteData(request, "/RetailSaaS/WriteProducts", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse writeUserEvents(ByteplusSaasRetail.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        return this.doWriteData(request, "/RetailSaaS/WriteUserEvents", opts);
    }

    private ByteplusSaasRetail.WriteResponse doWriteData(ByteplusSaasRetail.WriteDataRequest request, String path, Option ... opts) throws NetException, BizException {
        this.checkUploadDataRequest(request.getProjectId(), request.getStage());
        if (request.getDataCount() > 2000) {
            throw new BizException(ERR_MSG_TOO_MANY_WRITE_ITEMS);
        }
        Option[] newOpts = this.addSaasFlag(opts);
        Parser<ByteplusSaasRetail.WriteResponse> parser = ByteplusSaasRetail.WriteResponse.parser();
        ByteplusSaasRetail.WriteResponse response = (ByteplusSaasRetail.WriteResponse)this.httpClient.doPbRequest(path, (Message)request, parser, Option.conv2Options((Option[])newOpts));
        log.debug("[ByteplusSDK][WriteData] rsp:\n{}", (Object)response);
        return response;
    }

    private void checkUploadDataRequest(String projectId, String stage) throws BizException {
        String ERR_MSG_FORMAT = "%s,field can not empty";
        String ERR_FIELD_PROJECT_ID = "projectId";
        String ERR_FIELD_STAGE = "stage";
        if (this.noneEmptySting(projectId) && this.noneEmptySting(stage)) {
            return;
        }
        ArrayList<String> emptyParams = new ArrayList<String>();
        if (this.noneEmptySting(projectId)) {
            emptyParams.add("projectId");
        }
        if (this.noneEmptySting(stage)) {
            emptyParams.add("stage");
        }
        throw new BizException(String.format("%s,field can not empty", String.join((CharSequence)",", emptyParams)));
    }

    private Option[] addSaasFlag(Option[] opts) {
        String HTTPHeaderServerFrom = "Server-From";
        String SaasFlag = "saas";
        Option[] newOpts = new Option[opts.length + 1];
        System.arraycopy(opts, 0, newOpts, 0, opts.length);
        newOpts[newOpts.length - 1] = Option.withHeader((String)"Server-From", (String)"saas");
        return newOpts;
    }

    @Override
    public ByteplusSaasRetail.PredictResponse predict(ByteplusSaasRetail.PredictRequest request, Option ... opts) throws NetException, BizException {
        this.checkPredictRequest(request.getProjectId(), request.getModelId());
        Option[] newOpts = this.addSaasFlag(opts);
        Parser<ByteplusSaasRetail.PredictResponse> parser = ByteplusSaasRetail.PredictResponse.parser();
        ByteplusSaasRetail.PredictResponse response = (ByteplusSaasRetail.PredictResponse)this.httpClient.doPbRequest("/RetailSaaS/Predict", (Message)request, parser, Option.conv2Options((Option[])newOpts));
        log.debug("[ByteplusSDK][Predict] rsp:\n{}", (Object)response);
        return response;
    }

    private void checkPredictRequest(String projectId, String modelId) throws BizException {
        String ERR_MSG_FORMAT = "%s,field can not empty";
        String ERR_FIELD_PROJECT_ID = "projectId";
        String ERR_FIELD_MODEL_ID = "modelId";
        if (this.noneEmptySting(projectId) && this.noneEmptySting(modelId)) {
            return;
        }
        ArrayList<String> emptyParams = new ArrayList<String>();
        if (this.noneEmptySting(projectId)) {
            emptyParams.add("projectId");
        }
        if (this.noneEmptySting(modelId)) {
            emptyParams.add("modelId");
        }
        throw new BizException(String.format("%s,field can not empty", String.join((CharSequence)",", emptyParams)));
    }

    @Override
    public ByteplusSaasRetail.AckServerImpressionsResponse ackServerImpressions(ByteplusSaasRetail.AckServerImpressionsRequest request, Option ... opts) throws NetException, BizException {
        this.checkPredictRequest(request.getProjectId(), request.getModelId());
        Parser<ByteplusSaasRetail.AckServerImpressionsResponse> parser = ByteplusSaasRetail.AckServerImpressionsResponse.parser();
        Option[] newOpts = this.addSaasFlag(opts);
        ByteplusSaasRetail.AckServerImpressionsResponse response = (ByteplusSaasRetail.AckServerImpressionsResponse)this.httpClient.doPbRequest("/RetailSaaS/AckServerImpressions", (Message)request, parser, Option.conv2Options((Option[])newOpts));
        log.debug("[ByteplusSDK][AckImpressions] rsp:\n{}", (Object)response);
        return response;
    }

    @Override
    public final void release() {
        this.httpClient.Shutdown();
    }
}

