/*
 * Decompiled with CFR 0.152.
 */
package byteplus.rec.sdk.retail.example;

import byteplus.rec.core.BizException;
import byteplus.rec.core.Option;
import byteplus.rec.core.StatusHelper;
import byteplus.rec.core.Utils;
import byteplus.rec.sdk.region.Region;
import byteplus.rec.sdk.retail.RetailClient;
import byteplus.rec.sdk.retail.RetailClientBuilder;
import byteplus.rec.sdk.retail.example.MockHelper;
import byteplus.rec.sdk.retail.example.entity.DemoProduct;
import byteplus.rec.sdk.retail.example.entity.DemoUser;
import byteplus.rec.sdk.retail.example.entity.DemoUserEvent;
import byteplus.rec.sdk.retail.protocol.ByteplusSaasRetail;
import com.alibaba.fastjson.JSON;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final RetailClient client;
    private static final int DEFAULT_RETRY_TIMES = 2;
    private static final Duration DEFAULT_WRITE_TIMEOUT;
    private static final Duration DEFAULT_PREDICT_TIMEOUT;
    private static final Duration DEFAULT_ACK_IMPRESSIONS_TIMEOUT;
    public static final String PROJECT_ID = "***********";
    public static final String MODEL_ID = "***********";

    public static void main(String[] args) {
        Main.writeUsersExample();
        Main.writeProductsExample();
        Main.writeUserEventsExample();
        Main.recommendExample();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        client.release();
        System.exit(0);
    }

    public static void writeUsersExample() {
        ByteplusSaasRetail.WriteResponse response;
        ByteplusSaasRetail.WriteDataRequest request = Main.buildWriteUsersRequest(1);
        Option[] opts = Main.defaultOptions(DEFAULT_WRITE_TIMEOUT);
        try {
            response = (ByteplusSaasRetail.WriteResponse)Utils.doWithRetry(client::writeUsers, (Object)request, (Option[])opts, (int)2);
        }
        catch (BizException e) {
            log.error("write user occur err, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess((int)response.getStatus().getCode())) {
            log.info("write user success");
            return;
        }
        log.error("write user find failure info, msg:{} errItems:{}", (Object)response.getStatus(), response.getErrorsList());
    }

    private static ByteplusSaasRetail.WriteDataRequest buildWriteUsersRequest(int count) {
        List<DemoUser> users = MockHelper.mockUsers(count);
        ByteplusSaasRetail.WriteDataRequest.Builder requestBuilder = ByteplusSaasRetail.WriteDataRequest.newBuilder();
        requestBuilder.setProjectId("***********");
        requestBuilder.setStage("trial");
        for (DemoUser user : users) {
            requestBuilder.addData(JSON.toJSONString((Object)user));
        }
        return requestBuilder.build();
    }

    public static void writeProductsExample() {
        ByteplusSaasRetail.WriteResponse response;
        ByteplusSaasRetail.WriteDataRequest request = Main.buildWriteProductsRequest(1);
        Option[] options = Main.defaultOptions(DEFAULT_WRITE_TIMEOUT);
        try {
            response = (ByteplusSaasRetail.WriteResponse)Utils.doWithRetry(client::writeProducts, (Object)request, (Option[])options, (int)2);
        }
        catch (BizException e) {
            log.error("write product occur err, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess((int)response.getStatus().getCode())) {
            log.info("write product success");
            return;
        }
        log.error("write product find failure info, msg:{} errItems:{}", (Object)response.getStatus(), response.getErrorsList());
    }

    private static ByteplusSaasRetail.WriteDataRequest buildWriteProductsRequest(int count) {
        List<DemoProduct> products = MockHelper.mockProducts(count);
        ByteplusSaasRetail.WriteDataRequest.Builder requestBuilder = ByteplusSaasRetail.WriteDataRequest.newBuilder();
        requestBuilder.setProjectId("***********");
        requestBuilder.setStage("trial");
        for (DemoProduct product : products) {
            requestBuilder.addData(JSON.toJSONString((Object)product));
        }
        return requestBuilder.build();
    }

    public static void writeUserEventsExample() {
        ByteplusSaasRetail.WriteResponse response;
        ByteplusSaasRetail.WriteDataRequest request = Main.buildWriteUserEventsRequest(1);
        Option[] options = Main.defaultOptions(DEFAULT_WRITE_TIMEOUT);
        try {
            response = (ByteplusSaasRetail.WriteResponse)Utils.doWithRetry(client::writeUserEvents, (Object)request, (Option[])options, (int)2);
        }
        catch (BizException e) {
            log.error("write user events occur err, msg:{}", (Object)e.getMessage());
            return;
        }
        if (StatusHelper.isUploadSuccess((int)response.getStatus().getCode())) {
            log.info("write user events success");
            return;
        }
        log.error("write user events find failure info, msg:{} errItems:{}", (Object)response.getStatus(), response.getErrorsList());
    }

    private static ByteplusSaasRetail.WriteDataRequest buildWriteUserEventsRequest(int count) {
        List<DemoUserEvent> userEvents = MockHelper.mockUserEvents(count);
        ByteplusSaasRetail.WriteDataRequest.Builder requestBuilder = ByteplusSaasRetail.WriteDataRequest.newBuilder();
        requestBuilder.setProjectId("***********");
        requestBuilder.setStage("trial");
        for (DemoUserEvent userEvent : userEvents) {
            requestBuilder.addData(JSON.toJSONString((Object)userEvent));
        }
        return requestBuilder.build();
    }

    public static void recommendExample() {
        ByteplusSaasRetail.PredictResponse response;
        ByteplusSaasRetail.PredictRequest predictRequest = Main.buildPredictRequest();
        Option[] predict_opts = Main.defaultOptions(DEFAULT_PREDICT_TIMEOUT);
        try {
            response = client.predict(predictRequest, predict_opts);
        }
        catch (Exception e) {
            log.error("predict occur error, msg:{}", (Object)e.getMessage());
            return;
        }
        if (!StatusHelper.isSuccess((int)response.getStatus().getCode())) {
            log.error("predict find failure info, msg:{}", (Object)response.getStatus());
            return;
        }
        log.info("predict success");
        List<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct> alteredProducts = Main.doSomethingWithPredictResult(response.getValue());
        ByteplusSaasRetail.AckServerImpressionsRequest ackRequest = Main.buildAckRequest(response.getRequestId(), predictRequest, alteredProducts);
        Option[] ack_opts = Main.defaultOptions(DEFAULT_ACK_IMPRESSIONS_TIMEOUT);
        try {
            response = client.predict(predictRequest, predict_opts);
        }
        catch (Exception e) {
            log.error("predict occur error, msg:{}", (Object)e.getMessage());
            return;
        }
        Utils.Callable call = (req, optList) -> client.ackServerImpressions((ByteplusSaasRetail.AckServerImpressionsRequest)req, optList);
        try {
            Utils.doWithRetry((Utils.Callable)call, (Object)ackRequest, (Option[])ack_opts, (int)2);
        }
        catch (Exception e) {
            log.error("[AckServerImpressions] occur error, msg:{}", (Object)e.getMessage());
            return;
        }
    }

    private static ByteplusSaasRetail.PredictRequest buildPredictRequest() {
        ByteplusSaasRetail.Scene scene = ByteplusSaasRetail.Scene.newBuilder().setOffset(10).build();
        ByteplusSaasRetail.Product rootProduct = MockHelper.mockPredictProduct();
        ByteplusSaasRetail.Device device = MockHelper.mockDevice();
        ByteplusSaasRetail.PredictRequest.Context context = ByteplusSaasRetail.PredictRequest.Context.newBuilder().setRootProduct(rootProduct).setDevice(device).addAllCandidateProductIds(Arrays.asList("632462", "632463")).build();
        return ByteplusSaasRetail.PredictRequest.newBuilder().setProjectId("***********").setModelId("***********").setUserId("1457789").setSize(20).setScene(scene).setContext(context).build();
    }

    private static List<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct> doSomethingWithPredictResult(ByteplusSaasRetail.PredictResult predictResult) {
        return Main.conv2AlteredProducts(predictResult.getResponseProductsList());
    }

    @NotNull
    private static List<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct> conv2AlteredProducts(List<ByteplusSaasRetail.PredictResult.ResponseProduct> products) {
        if (Objects.isNull(products) || products.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct> alteredProducts = new ArrayList<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct>(products.size());
        for (int i = 0; i < products.size(); ++i) {
            ByteplusSaasRetail.PredictResult.ResponseProduct responseProduct = products.get(i);
            ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct alteredProduct = ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct.newBuilder().setAlteredReason("kept").setProductId(responseProduct.getProductId()).setRank(i + 1).build();
            alteredProducts.add(alteredProduct);
        }
        return alteredProducts;
    }

    private static ByteplusSaasRetail.AckServerImpressionsRequest buildAckRequest(String predictRequestId, ByteplusSaasRetail.PredictRequest predictRequest, List<ByteplusSaasRetail.AckServerImpressionsRequest.AlteredProduct> alteredProducts) {
        return ByteplusSaasRetail.AckServerImpressionsRequest.newBuilder().setProjectId(predictRequest.getProjectId()).setModelId(predictRequest.getModelId()).setPredictRequestId(predictRequestId).setUserId(predictRequest.getUserId()).setScene(predictRequest.getScene()).addAllAlteredProducts(alteredProducts).build();
    }

    private static Option[] defaultOptions(Duration timeout) {
        return new Option[]{Option.withRequestId((String)UUID.randomUUID().toString()), Option.withTimeout((Duration)timeout)};
    }

    static {
        DEFAULT_WRITE_TIMEOUT = Duration.ofMillis(800L);
        DEFAULT_PREDICT_TIMEOUT = Duration.ofMillis(800L);
        DEFAULT_ACK_IMPRESSIONS_TIMEOUT = Duration.ofMillis(800L);
        client = new RetailClientBuilder().tenantID("***********").region(Region.SG).ak("***********").sk("***********").build();
    }
}

