/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.sdk.retail;

import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.HTTPClient;
import com.byteplus.rec.core.NetException;
import com.byteplus.rec.core.Option;
import com.byteplus.rec.core.Utils;
import com.byteplus.rec.sdk.retail.RetailClient;
import com.byteplus.rec.sdk.retail.protocol.ByteplusSaasRetail;
import com.google.protobuf.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetailClientImpl
implements RetailClient {
    private static final Logger log = LoggerFactory.getLogger(RetailClientImpl.class);
    private static final String ERR_MSG_TOO_MANY_WRITE_ITEMS = String.format("Only can receive max to %d items in one write request", 2000);
    private final HTTPClient httpClient;

    protected RetailClientImpl(HTTPClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public ByteplusSaasRetail.WriteResponse writeUsers(ByteplusSaasRetail.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        return this.doWriteData(request, "/RetailSaaS/WriteUsers", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse writeProducts(ByteplusSaasRetail.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        return this.doWriteData(request, "/RetailSaaS/WriteProducts", opts);
    }

    @Override
    public ByteplusSaasRetail.WriteResponse writeUserEvents(ByteplusSaasRetail.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        return this.doWriteData(request, "/RetailSaaS/WriteUserEvents", opts);
    }

    private ByteplusSaasRetail.WriteResponse doWriteData(ByteplusSaasRetail.WriteDataRequest request, String path, Option ... opts) throws NetException, BizException {
        this.checkUploadDataRequest(request);
        if (request.getDataCount() > 2000) {
            throw new BizException(ERR_MSG_TOO_MANY_WRITE_ITEMS);
        }
        ByteplusSaasRetail.WriteResponse response = (ByteplusSaasRetail.WriteResponse)this.httpClient.doPBRequest(path, (Message)request, ByteplusSaasRetail.WriteResponse.parser(), Option.conv2Options((Option[])opts));
        log.debug("[ByteplusSDK][WriteData] req:\n{} rsp:\n{}", (Object)request, (Object)response);
        return response;
    }

    private void checkUploadDataRequest(ByteplusSaasRetail.WriteDataRequest request) throws BizException {
        if (Utils.isEmptyString((String)request.getProjectId())) {
            throw new BizException("project id is empty");
        }
        if (Utils.isEmptyString((String)request.getStage())) {
            throw new BizException("stage is empty");
        }
    }

    @Override
    public ByteplusSaasRetail.PredictResponse predict(ByteplusSaasRetail.PredictRequest request, Option ... opts) throws NetException, BizException {
        this.checkPredictRequest(request);
        ByteplusSaasRetail.PredictResponse response = (ByteplusSaasRetail.PredictResponse)this.httpClient.doPBRequest("/RetailSaaS/Predict", (Message)request, ByteplusSaasRetail.PredictResponse.parser(), Option.conv2Options((Option[])opts));
        log.debug("[ByteplusSDK][Predict] req:\n{} rsp:\n{}", (Object)request, (Object)response);
        return response;
    }

    private void checkPredictRequest(ByteplusSaasRetail.PredictRequest request) throws BizException {
        if (Utils.isEmptyString((String)request.getProjectId())) {
            throw new BizException("project id is empty");
        }
        if (Utils.isEmptyString((String)request.getModelId())) {
            throw new BizException("model id is empty");
        }
    }

    @Override
    public ByteplusSaasRetail.AckServerImpressionsResponse ackServerImpressions(ByteplusSaasRetail.AckServerImpressionsRequest request, Option ... opts) throws NetException, BizException {
        this.checkAckRequest(request);
        ByteplusSaasRetail.AckServerImpressionsResponse response = (ByteplusSaasRetail.AckServerImpressionsResponse)this.httpClient.doPBRequest("/RetailSaaS/AckServerImpressions", (Message)request, ByteplusSaasRetail.AckServerImpressionsResponse.parser(), Option.conv2Options((Option[])opts));
        log.debug("[ByteplusSDK][AckImpressions] req:\n{} rsp:\n{}", (Object)request, (Object)response);
        return response;
    }

    private void checkAckRequest(ByteplusSaasRetail.AckServerImpressionsRequest request) throws BizException {
        if (Utils.isEmptyString((String)request.getProjectId())) {
            throw new BizException("project id is empty");
        }
        if (Utils.isEmptyString((String)request.getModelId())) {
            throw new BizException("model id is empty");
        }
    }

    @Override
    public final void release() {
        this.httpClient.shutdown();
    }
}

