/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.sdk.content;

import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.HTTPCaller;
import com.byteplus.rec.core.HTTPClient;
import com.byteplus.rec.core.HostAvailablerFactory;
import com.byteplus.rec.core.IRegion;
import com.byteplus.rec.core.Utils;
import com.byteplus.rec.core.metrics.MetricsCollector;
import com.byteplus.rec.sdk.content.ContentClientImpl;
import java.util.List;
import java.util.Objects;

public class ContentClientBuilder {
    private static final String BYTEPLUS_AUTH_SERVICE = "byteplus_recommend";
    private String tenantID;
    private String projectID;
    private String airAuthToken;
    private String authAK;
    private String authSK;
    private String schema;
    private List<String> hosts;
    private IRegion region;
    private boolean keepAlive;
    private HTTPCaller.Config callerConfig;
    private HostAvailablerFactory hostAvailablerFactory;
    private MetricsCollector.MetricsCfg metricsConfig;

    public ContentClientBuilder accountID(String accountID) {
        this.tenantID = accountID;
        return this;
    }

    public ContentClientImpl build() throws BizException {
        this.checkRequiredField();
        HTTPClient httpClient = HTTPClient.builder().tenantID(this.tenantID).projectID(this.projectID).airAuthToken(this.airAuthToken).authAK(this.authAK).authSK(this.authSK).schema(this.schema).hosts(this.hosts).region(this.region).useAirAuth(this.isUseAirAuth()).authService(BYTEPLUS_AUTH_SERVICE).callerConfig(this.callerConfig).hostAvailablerFactory(this.hostAvailablerFactory).metricsCfg(this.metricsConfig).keepAlive(this.keepAlive).build();
        return new ContentClientImpl(httpClient, this.projectID);
    }

    private boolean isUseAirAuth() {
        return Utils.isAllEmptyString((String[])new String[]{this.authAK, this.authSK}) && Utils.noneEmptyString((String[])new String[]{this.airAuthToken});
    }

    private void checkRequiredField() throws BizException {
        if (Objects.isNull(this.projectID)) {
            throw new BizException("project id is empty");
        }
    }

    public ContentClientBuilder tenantID(String tenantID) {
        this.tenantID = tenantID;
        return this;
    }

    public ContentClientBuilder projectID(String projectID) {
        this.projectID = projectID;
        return this;
    }

    public ContentClientBuilder airAuthToken(String airAuthToken) {
        this.airAuthToken = airAuthToken;
        return this;
    }

    public ContentClientBuilder authAK(String authAK) {
        this.authAK = authAK;
        return this;
    }

    public ContentClientBuilder authSK(String authSK) {
        this.authSK = authSK;
        return this;
    }

    public ContentClientBuilder schema(String schema) {
        this.schema = schema;
        return this;
    }

    public ContentClientBuilder hosts(List<String> hosts) {
        this.hosts = hosts;
        return this;
    }

    public ContentClientBuilder region(IRegion region) {
        this.region = region;
        return this;
    }

    public ContentClientBuilder keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public ContentClientBuilder callerConfig(HTTPCaller.Config callerConfig) {
        this.callerConfig = callerConfig;
        return this;
    }

    public ContentClientBuilder hostAvailablerFactory(HostAvailablerFactory hostAvailablerFactory) {
        this.hostAvailablerFactory = hostAvailablerFactory;
        return this;
    }

    public ContentClientBuilder metricsConfig(MetricsCollector.MetricsCfg metricsConfig) {
        this.metricsConfig = metricsConfig;
        return this;
    }
}

