/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.sdk.content;

import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.HTTPClient;
import com.byteplus.rec.core.NetException;
import com.byteplus.rec.core.Option;
import com.byteplus.rec.core.Utils;
import com.byteplus.rec.sdk.content.ContentClient;
import com.byteplus.rec.sdk.content.protocol.ByteplusSaasContent;
import com.google.protobuf.Message;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentClientImpl
implements ContentClient {
    private static final Logger log = LoggerFactory.getLogger(ContentClientImpl.class);
    private static final String ERR_MSG_TOO_MANY_WRITE_ITEMS = String.format("Only can receive max to %d items in one write request", 2000);
    private static final String ERR_MSG_TOO_MANY_FINISH_DATES = String.format("Only can receive max to %d dates in one finish request", 100);
    private final HTTPClient httpClient;
    private final String projectID;

    protected ContentClientImpl(HTTPClient httpClient, String projectID) {
        this.httpClient = httpClient;
        this.projectID = projectID;
    }

    @Override
    public ByteplusSaasContent.WriteResponse writeUsers(ByteplusSaasContent.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasContent.WriteDataRequest writeRequest = request.toBuilder().setTopic("user").build();
        return this.doWriteData(writeRequest, "/ContentSaaS/WriteUsers", opts);
    }

    @Override
    public ByteplusSaasContent.WriteResponse finishWriteUsers(ByteplusSaasContent.FinishWriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasContent.FinishWriteDataRequest finishRequest = request.toBuilder().setTopic("user").build();
        return this.doFinishData(finishRequest, "/ContentSaaS/FinishWriteUsers", opts);
    }

    @Override
    public ByteplusSaasContent.WriteResponse writeContents(ByteplusSaasContent.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasContent.WriteDataRequest writeRequest = request.toBuilder().setTopic("content").build();
        return this.doWriteData(writeRequest, "/ContentSaaS/WriteContents", opts);
    }

    @Override
    public ByteplusSaasContent.WriteResponse finishWriteContents(ByteplusSaasContent.FinishWriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasContent.FinishWriteDataRequest finishRequest = request.toBuilder().setTopic("content").build();
        return this.doFinishData(finishRequest, "/ContentSaaS/FinishWriteContents", opts);
    }

    @Override
    public ByteplusSaasContent.WriteResponse writeUserEvents(ByteplusSaasContent.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasContent.WriteDataRequest writeRequest = request.toBuilder().setTopic("behavior").build();
        return this.doWriteData(writeRequest, "/ContentSaaS/WriteUserEvents", opts);
    }

    @Override
    public ByteplusSaasContent.WriteResponse finishWriteUserEvents(ByteplusSaasContent.FinishWriteDataRequest request, Option ... opts) throws NetException, BizException {
        ByteplusSaasContent.FinishWriteDataRequest finishRequest = request.toBuilder().setTopic("behavior").build();
        return this.doFinishData(finishRequest, "/ContentSaaS/FinishWriteUserEvents", opts);
    }

    @Override
    public ByteplusSaasContent.WriteResponse writeOthers(ByteplusSaasContent.WriteDataRequest request, Option ... opts) throws NetException, BizException {
        return this.doWriteData(request, "/ContentSaaS/WriteOthers", opts);
    }

    @Override
    public ByteplusSaasContent.WriteResponse finishWriteOthers(ByteplusSaasContent.FinishWriteDataRequest request, Option ... opts) throws NetException, BizException {
        return this.doFinishData(request, "/ContentSaaS/FinishWriteOthers", opts);
    }

    private ByteplusSaasContent.WriteResponse doWriteData(ByteplusSaasContent.WriteDataRequest request, String path, Option ... opts) throws NetException, BizException {
        if (Objects.nonNull(this.projectID) && request.getProjectId().length() == 0) {
            request = request.toBuilder().setProjectId(this.projectID).build();
        }
        this.checkWriteDataRequest(request);
        ByteplusSaasContent.WriteResponse response = (ByteplusSaasContent.WriteResponse)this.httpClient.doPBRequest(path, (Message)request, ByteplusSaasContent.WriteResponse.parser(), Option.conv2Options((Option[])opts));
        log.debug("[ByteplusSDK][WriteData] req:\n{} rsp:\n{}", (Object)request, (Object)response);
        return response;
    }

    private void checkWriteDataRequest(ByteplusSaasContent.WriteDataRequest request) throws BizException {
        if (Utils.isEmptyString((String)request.getProjectId())) {
            throw new BizException("project id is empty");
        }
        if (Utils.isEmptyString((String)request.getStage())) {
            throw new BizException("stage is empty");
        }
        if (request.getDataCount() > 2000) {
            throw new BizException(ERR_MSG_TOO_MANY_WRITE_ITEMS);
        }
    }

    private ByteplusSaasContent.WriteResponse doFinishData(ByteplusSaasContent.FinishWriteDataRequest request, String path, Option ... opts) throws NetException, BizException {
        if (Objects.nonNull(this.projectID) && request.getProjectId().length() == 0) {
            request = request.toBuilder().setProjectId(this.projectID).build();
        }
        this.checkFinishWriteRequest(request);
        ByteplusSaasContent.WriteResponse response = (ByteplusSaasContent.WriteResponse)this.httpClient.doPBRequest(path, (Message)request, ByteplusSaasContent.WriteResponse.parser(), Option.conv2Options((Option[])opts));
        log.debug("[ByteplusSDK][FinishWriteData] req:\n{} rsp:\n{}", (Object)request, (Object)response);
        return response;
    }

    private void checkFinishWriteRequest(ByteplusSaasContent.FinishWriteDataRequest request) throws BizException {
        if (Utils.isEmptyString((String)request.getProjectId())) {
            throw new BizException("project id is empty");
        }
        if (Utils.isEmptyString((String)request.getStage())) {
            throw new BizException("stage is empty");
        }
        if (Utils.isEmptyString((String)request.getTopic())) {
            throw new BizException("topic is empty");
        }
        if (request.getDataDatesCount() > 100) {
            throw new BizException(ERR_MSG_TOO_MANY_FINISH_DATES);
        }
    }

    @Override
    public ByteplusSaasContent.PredictResponse predict(ByteplusSaasContent.PredictRequest request, Option ... opts) throws NetException, BizException {
        if (Objects.nonNull(this.projectID) && request.getProjectId().length() == 0) {
            request = request.toBuilder().setProjectId(this.projectID).build();
        }
        this.checkPredictRequest(request);
        ByteplusSaasContent.PredictResponse response = (ByteplusSaasContent.PredictResponse)this.httpClient.doPBRequest("/ContentSaaS/Predict", (Message)request, ByteplusSaasContent.PredictResponse.parser(), Option.conv2Options((Option[])opts));
        log.debug("[ByteplusSDK][Predict] req:\n{} rsp:\n{}", (Object)request, (Object)response);
        return response;
    }

    private void checkPredictRequest(ByteplusSaasContent.PredictRequest request) throws BizException {
        if (Utils.isEmptyString((String)request.getProjectId())) {
            throw new BizException("project id is empty");
        }
        if (Utils.isEmptyString((String)request.getModelId())) {
            throw new BizException("model id is empty");
        }
    }

    @Override
    public ByteplusSaasContent.AckServerImpressionsResponse ackServerImpressions(ByteplusSaasContent.AckServerImpressionsRequest request, Option ... opts) throws NetException, BizException {
        if (Objects.nonNull(this.projectID) && request.getProjectId().length() == 0) {
            request = request.toBuilder().setProjectId(this.projectID).build();
        }
        this.checkAckRequest(request);
        ByteplusSaasContent.AckServerImpressionsResponse response = (ByteplusSaasContent.AckServerImpressionsResponse)this.httpClient.doPBRequest("/ContentSaaS/AckServerImpressions", (Message)request, ByteplusSaasContent.AckServerImpressionsResponse.parser(), Option.conv2Options((Option[])opts));
        log.debug("[ByteplusSDK][AckImpressions] req:\n{} rsp:\n{}", (Object)request, (Object)response);
        return response;
    }

    private void checkAckRequest(ByteplusSaasContent.AckServerImpressionsRequest request) throws BizException {
        if (Utils.isEmptyString((String)request.getProjectId())) {
            throw new BizException("project id is empty");
        }
        if (Utils.isEmptyString((String)request.getModelId())) {
            throw new BizException("model id is empty");
        }
    }

    @Override
    public void release() {
        this.httpClient.shutdown();
    }
}

