/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.HostAvailabler;
import com.byteplus.rec.core.Utils;
import com.byteplus.rec.core.metrics.Metrics;
import com.byteplus.rec.core.metrics.MetricsLog;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHostAvailabler
implements HostAvailabler {
    private static final Logger log = LoggerFactory.getLogger(AbstractHostAvailabler.class);
    private static final Duration DEFAULT_FETCH_HOST_INTERVAL = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_SCORE_HOST_INTERVAL = Duration.ofSeconds(1L);
    private static final double MAIN_HOST_AVAILABLE_SCORE = 0.9;
    private final Clock clock = Clock.systemDefaultZone();
    protected String projectID;
    private List<String> defaultHosts;
    private String mainHost;
    private boolean skipFetchHosts;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> fetchHostsFromServerFuture;
    private OkHttpClient fetchHostsHTTPClient;
    private volatile Map<String, List<String>> hostConfig;

    public AbstractHostAvailabler(List<String> defaultHosts, boolean initImmediately) throws BizException {
        if (Objects.isNull(defaultHosts) || defaultHosts.isEmpty()) {
            throw new BizException("default hosts are empty");
        }
        this.projectID = "";
        this.defaultHosts = defaultHosts;
        if (initImmediately) {
            this.init(DEFAULT_FETCH_HOST_INTERVAL, DEFAULT_SCORE_HOST_INTERVAL);
        }
    }

    public AbstractHostAvailabler(String projectID, List<String> defaultHosts, boolean initImmediately) throws BizException {
        if (Objects.isNull(projectID) || projectID.isEmpty()) {
            throw new BizException("project is empty");
        }
        if (Objects.isNull(defaultHosts) || defaultHosts.isEmpty()) {
            throw new BizException("default hosts are empty");
        }
        this.projectID = projectID;
        this.defaultHosts = defaultHosts;
        if (initImmediately) {
            this.init(DEFAULT_FETCH_HOST_INTERVAL, DEFAULT_SCORE_HOST_INTERVAL);
        }
    }

    public AbstractHostAvailabler(String projectID, List<String> defaultHosts, String mainHost, boolean skipFetchHosts, boolean initImmediately) throws BizException {
        if (Objects.isNull(projectID) || projectID.isEmpty()) {
            throw new BizException("project is empty");
        }
        if (Objects.isNull(defaultHosts) || defaultHosts.isEmpty()) {
            throw new BizException("default hosts are empty");
        }
        this.projectID = projectID;
        this.defaultHosts = defaultHosts;
        this.mainHost = mainHost;
        this.skipFetchHosts = skipFetchHosts;
        if (initImmediately) {
            this.init(DEFAULT_FETCH_HOST_INTERVAL, DEFAULT_SCORE_HOST_INTERVAL);
        }
    }

    protected void init(Duration fetchHostInterval, Duration scoreHostInterval) throws BizException {
        this.setHosts(this.defaultHosts);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        if (!this.skipFetchHosts) {
            this.fetchHostsHTTPClient = Utils.buildOkHTTPClient(Duration.ofSeconds(5L));
            this.fetchHostsFromServer();
            this.fetchHostsFromServerFuture = this.executor.scheduleAtFixedRate(this::fetchHostsFromServer, fetchHostInterval.toMillis(), fetchHostInterval.toMillis(), TimeUnit.MILLISECONDS);
        }
        this.executor.scheduleAtFixedRate(this::scoreAndUpdateHosts, scoreHostInterval.toMillis(), scoreHostInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void setHosts(List<String> hosts) throws BizException {
        if (Objects.isNull(hosts) || hosts.isEmpty()) {
            throw new BizException("host array is empty");
        }
        this.defaultHosts = hosts;
        this.stopFetchHostsFromServer();
        this.doScoreAndUpdateHosts(Collections.singletonMap("*", hosts));
    }

    private void stopFetchHostsFromServer() {
        if (Objects.nonNull(this.fetchHostsFromServerFuture)) {
            this.fetchHostsFromServerFuture.cancel(true);
        }
        if (Objects.nonNull(this.fetchHostsHTTPClient)) {
            this.fetchHostsHTTPClient = null;
        }
    }

    private void fetchHostsFromServer() {
        String url = String.format("http://%s/data/api/sdk/host?project_id=%s", this.defaultHosts.get(0), this.projectID);
        String reqID = "fetch_" + UUID.randomUUID().toString();
        for (int i = 0; i < 3; ++i) {
            Map<String, List<String>> rspHostConfig = this.doFetchHostsFromServer(reqID, url);
            if (Objects.isNull(rspHostConfig)) continue;
            if (this.isServerHostsNotUpdated(rspHostConfig)) {
                String metricsLogFormat = "[ByteplusSDK][Fetch] hosts from server are not changed, project_id:%s, config:%s";
                MetricsLog.info(reqID, metricsLogFormat, this.projectID, rspHostConfig);
                log.debug("[ByteplusSDK] hosts from server are not changed, config: {}", (Object)rspHostConfig);
                return;
            }
            if (!rspHostConfig.containsKey("*") || rspHostConfig.get("*").isEmpty()) {
                String[] metricsTags = new String[]{"type:no_default_hosts", "url:" + Utils.escapeMetricsTagValue(url), "project_id:" + this.projectID};
                Metrics.counter("common.warn", 1L, metricsTags);
                String metricsLogFormat = "[ByteplusSDK][Fetch] no default value in hosts from server, project_id:%s, config:%s";
                MetricsLog.warn(reqID, metricsLogFormat, this.projectID, rspHostConfig);
                log.warn("[ByteplusSDK] no default value in hosts from server, config: {}", (Object)rspHostConfig);
                return;
            }
            this.doScoreAndUpdateHosts(rspHostConfig);
            return;
        }
        String[] metricsTags = new String[]{"type:fetch_host_fail_although_retried", "url:" + Utils.escapeMetricsTagValue(url), "project_id:" + this.projectID};
        Metrics.counter("common.err", 1L, metricsTags);
        String metricsLogFormat = "[ByteplusSDK][Fetch] fetch host from server fail although retried, project_id:%s url:%s";
        MetricsLog.warn(reqID, metricsLogFormat, this.projectID, url);
        log.warn("[ByteplusSDK] fetch host from server fail although retried, url: {}", (Object)url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<String>> doFetchHostsFromServer(String reqID, String url) {
        long start = this.clock.millis();
        Headers headers = new Headers.Builder().set("Request-Id", reqID).set("Project-Id", this.projectID).build();
        Request httpRequest = new Request.Builder().url(url).headers(headers).get().build();
        Call httpCall = this.fetchHostsHTTPClient.newCall(httpRequest);
        try (Response httpRsp = httpCall.execute();){
            long cost = this.clock.millis() - start;
            if (httpRsp.code() == 404) {
                String[] metricsTags = new String[]{"type:fetch_host_status_400", "url:" + Utils.escapeMetricsTagValue(url), "project_id:" + this.projectID};
                Metrics.counter("common.err", 1L, metricsTags);
                String metricsLogFormat = "[ByteplusSDK][Fetch] fetch host from server return not found status, project_id:%s cost:%dms";
                MetricsLog.warn(reqID, metricsLogFormat, this.projectID, cost);
                log.warn("[ByteplusSDK] fetch host from server return not found status, cost:{}ms", (Object)cost);
                Map<String, List<String>> map = Collections.emptyMap();
                return map;
            }
            if (httpRsp.code() != 200) {
                String[] metricsTags = new String[]{"type:fetch_host_not_ok", "url:" + Utils.escapeMetricsTagValue(url), "project_id:" + this.projectID};
                Metrics.counter("common.err", 1L, metricsTags);
                String metricsLogFormat = "[ByteplusSDK][Fetch] fetch host from server return not ok status, project_id:%s, status:%d, cost:%dms";
                MetricsLog.warn(reqID, metricsLogFormat, this.projectID, httpRsp.code(), cost);
                log.warn("[ByteplusSDK] fetch host from server return not ok status:{} cost:{}ms", (Object)httpRsp.code(), (Object)cost);
                Map<String, List<String>> map = null;
                return map;
            }
            ResponseBody rspBody = httpRsp.body();
            String rspBodyStr = Objects.isNull(rspBody) ? null : new String(rspBody.bytes(), StandardCharsets.UTF_8);
            String[] metricsTags = new String[]{"url:" + Utils.escapeMetricsTagValue(url), "project_id:" + this.projectID};
            Metrics.counter("request.count", 1L, metricsTags);
            Metrics.timer("request.total.cost", cost, metricsTags);
            String metricsLogFormat = "[ByteplusSDK][Fetch] fetch host from server, project_id:%s, url:%s, cost:%dms, rsp: %s";
            MetricsLog.info(reqID, metricsLogFormat, this.projectID, url, cost, rspBodyStr);
            log.debug("[ByteplusSDK] fetch host from server, cost:{}ms rsp:{}", (Object)cost, (Object)rspBodyStr);
            if (Objects.nonNull(rspBodyStr) && rspBodyStr.length() > 0) {
                Map<String, List<String>> map = JSON.parseObject(rspBodyStr, new TypeReference<Map<String, List<String>>>(){}, new Feature[0]);
                return map;
            }
            log.warn("[ByteplusSDK] hosts from server are empty");
            Map<String, List<String>> map = Collections.emptyMap();
            return map;
        }
        catch (Throwable e) {
            long cost = this.clock.millis() - start;
            String[] metricsTags = new String[]{"type:fetch_host_fail", "url:" + Utils.escapeMetricsTagValue(url), "project_id:" + this.projectID};
            Metrics.counter("common.err", 1L, metricsTags);
            String metricsLogFormat = "[ByteplusSDK][Fetch] fetch host from server fail, project_id:%s, url:%s, cost:%dms, err: %s";
            MetricsLog.warn(reqID, metricsLogFormat, this.projectID, url, cost, e.toString());
            log.warn("[ByteplusSDK] fetch host from server fail, url:{} cost:{}ms err:{}", url, cost, e.toString());
            return null;
        }
    }

    private boolean isServerHostsNotUpdated(Map<String, List<String>> newHostConfig) {
        if (newHostConfig.size() != this.hostConfig.size()) {
            return false;
        }
        Set<String> paths = newHostConfig.keySet();
        for (String path : paths) {
            List<String> oldPathHosts = this.hostConfig.get(path);
            List<String> newPathHosts = newHostConfig.get(path);
            if (Objects.isNull(oldPathHosts)) {
                return false;
            }
            if (oldPathHosts.size() != newPathHosts.size()) {
                return false;
            }
            if (newPathHosts.containsAll(oldPathHosts)) continue;
            return false;
        }
        return true;
    }

    private void scoreAndUpdateHosts() {
        this.doScoreAndUpdateHosts(this.hostConfig);
    }

    private void doScoreAndUpdateHosts(Map<String, List<String>> hostConfig) {
        String logID = "score_" + UUID.randomUUID().toString();
        List<String> hosts = this.distinctHosts(hostConfig);
        List<HostAvailabilityScore> newHostScores = this.doScoreHosts(hosts);
        MetricsLog.info(logID, "[ByteplusSDK][Score] score hosts, project_id:%s, result:%s", this.projectID, newHostScores);
        log.debug("[ByteplusSDK] score hosts result: {}", (Object)newHostScores);
        if (Objects.isNull(newHostScores) || newHostScores.isEmpty()) {
            String[] metricsTags = new String[]{"type:scoring_hosts_return_empty_list", "project_id:" + this.projectID};
            Metrics.counter("common.err", 1L, metricsTags);
            MetricsLog.error(logID, "[ByteplusSDK][Score] scoring hosts return an empty list, project_id:%s", this.projectID);
            log.error("[ByteplusSDK] scoring hosts return an empty list");
            return;
        }
        Map<String, List<String>> newHostConfig = this.copyAndSortHost(hostConfig, newHostScores);
        if (this.isHostConfigNotUpdated(this.hostConfig, newHostConfig)) {
            MetricsLog.info(logID, "[ByteplusSDK][Score] host order is not changed, project_id:%s, hosts:%s", this.projectID, newHostScores);
            log.debug("[ByteplusSDK] host order is not changed, {}", (Object)newHostConfig);
            return;
        }
        String[] metricsTags = new String[]{"type:set_new_host_config", "project_id:" + this.projectID};
        Metrics.counter("common.info", 1L, metricsTags);
        MetricsLog.info(logID, "[ByteplusSDK][Score] set new host config: %s, old config: %s, project_id: %s", newHostConfig, hostConfig, this.projectID);
        log.warn("[ByteplusSDK] set new host config: {}, old config: {}", (Object)newHostConfig, (Object)hostConfig);
        this.hostConfig = newHostConfig;
    }

    private List<String> distinctHosts(Map<String, List<String>> hostConfig) {
        HashSet hostSet = new HashSet();
        hostConfig.forEach((path, hosts) -> hostSet.addAll(hosts));
        return new ArrayList<String>(hostSet);
    }

    protected abstract List<HostAvailabilityScore> doScoreHosts(List<String> var1);

    private Map<String, List<String>> copyAndSortHost(Map<String, List<String>> hostConfig, List<HostAvailabilityScore> newHostScores) {
        Map<String, Double> hostScoreIndex = newHostScores.stream().collect(Collectors.toMap(HostAvailabilityScore::getHost, newHostScore -> newHostScore.getHost().equals(this.mainHost) && newHostScore.getScore() >= 0.9 ? 1.0 + newHostScore.getScore() : newHostScore.getScore()));
        HashMap<String, List<String>> newHostConfig = new HashMap<String, List<String>>();
        hostConfig.forEach((path, hosts) -> {
            ArrayList newHosts = new ArrayList(hosts);
            newHosts.sort((x, y) -> {
                double scoreY;
                double scoreX = hostScoreIndex.getOrDefault(x, 0.0);
                double delta = scoreX - (scoreY = hostScoreIndex.getOrDefault(y, 0.0).doubleValue());
                if (delta == 0.0) {
                    return 0;
                }
                return delta > 0.0 ? -1 : 1;
            });
            newHostConfig.put((String)path, newHosts);
        });
        return newHostConfig;
    }

    private boolean isHostConfigNotUpdated(Map<String, List<String>> oldHostConfig, Map<String, List<String>> newHostConfig) {
        if (Objects.isNull(oldHostConfig)) {
            return false;
        }
        if (Objects.isNull(newHostConfig)) {
            return true;
        }
        if (oldHostConfig.size() != newHostConfig.size()) {
            return false;
        }
        Set<String> pathSet = oldHostConfig.keySet();
        for (String path : pathSet) {
            List<String> newHosts;
            List<String> oldHosts = oldHostConfig.get(path);
            if (oldHosts.equals(newHosts = newHostConfig.get(path))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getHost(String httpPath) {
        List<String> hosts = this.hostConfig.get(httpPath);
        if (Objects.isNull(hosts) || hosts.isEmpty()) {
            return this.hostConfig.get("*").get(0);
        }
        return hosts.get(0);
    }

    @Override
    public List<String> getHosts() {
        return this.distinctHosts(this.hostConfig);
    }

    @Override
    public void shutdown() {
        if (Objects.isNull(this.executor)) {
            return;
        }
        this.executor.shutdown();
    }

    protected static class HostAvailabilityScore {
        private final String host;
        private final double score;

        public String toString() {
            return "{host='" + this.host + '\'' + ", score=" + this.score + '}';
        }

        public HostAvailabilityScore(String host, double score) {
            this.host = host;
            this.score = score;
        }

        public String getHost() {
            return this.host;
        }

        public double getScore() {
            return this.score;
        }
    }
}

