/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.core;

import com.byteplus.rec.core.Auth;
import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.HTTPCaller;
import com.byteplus.rec.core.HostAvailabler;
import com.byteplus.rec.core.HostAvailablerFactory;
import com.byteplus.rec.core.IRegion;
import com.byteplus.rec.core.NetException;
import com.byteplus.rec.core.Options;
import com.byteplus.rec.core.Utils;
import com.byteplus.rec.core.metrics.MetricsCollector;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.util.List;
import java.util.Objects;
import okhttp3.OkHttpClient;

public class HTTPClient {
    private HTTPCaller httpCaller;
    private HostAvailabler hostAvailabler;
    private String schema;

    public <Rsp extends Message, Req extends Message> Rsp doPBRequest(String path, Req request, Parser<Rsp> rspParser, Options options) throws NetException, BizException {
        return this.httpCaller.doPBRequest(this.buildURL(path), request, rspParser, options);
    }

    public <Rsp> Rsp doJSONRequest(String path, Object request, Rsp response, Options options) throws NetException, BizException {
        return this.httpCaller.doJSONRequest(this.buildURL(path), request, response, options);
    }

    private String buildURL(String path) {
        String host = this.hostAvailabler.getHost(path);
        return Utils.buildURL(this.schema, host, path);
    }

    public void shutdown() {
        this.hostAvailabler.shutdown();
        this.httpCaller.shutdown();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected HTTPClient(HTTPCaller httpCaller, HostAvailabler hostAvailabler, String schema) {
        this.httpCaller = httpCaller;
        this.hostAvailabler = hostAvailabler;
        this.schema = schema;
    }

    public static class Builder {
        private static HostAvailabler globalHostAvailabler;
        private String tenantID;
        private String projectID;
        private boolean useAirAuth;
        private String airAuthToken;
        private String authAK;
        private String authSK;
        private String authService;
        private String schema;
        private List<String> hosts;
        private String mainHost;
        private IRegion region;
        private HostAvailablerFactory hostAvailablerFactory;
        private boolean keepAlive;
        private HTTPCaller.Config callerConfig;
        private HostAvailabler hostAvailabler;
        private MetricsCollector.MetricsCfg metricsCfg;
        @Deprecated
        private OkHttpClient callerClient;

        public HTTPClient build() throws BizException {
            this.checkRequiredField();
            this.fillDefault();
            if (!MetricsCollector.isInitialed() && Objects.nonNull(this.metricsCfg) && (this.metricsCfg.isEnableMetrics() || this.metricsCfg.isEnableMetricsLog())) {
                this.initGlobalHostAvailabler();
            }
            MetricsCollector.Init(this.metricsCfg, globalHostAvailabler);
            return new HTTPClient(this.newHTTPCaller(), this.hostAvailabler, this.schema);
        }

        private void checkRequiredField() throws BizException {
            if (Objects.isNull(this.tenantID)) {
                throw new BizException("tenant id is null");
            }
            this.checkAuthRequiredField();
            if (Objects.isNull(this.region)) {
                throw new BizException("region is null");
            }
        }

        private void checkAuthRequiredField() throws BizException {
            if (this.useAirAuth) {
                if (Objects.isNull(this.airAuthToken) || this.airAuthToken.equals("")) {
                    throw new BizException("token cannot be null");
                }
                return;
            }
            if (Objects.isNull(this.authAK) || this.authAK.equals("") || Objects.isNull(this.authSK) || this.authSK.equals("")) {
                throw new BizException("ak and sk cannot be null");
            }
        }

        private void fillDefault() throws BizException {
            if (Objects.isNull(this.schema) || this.schema.equals("")) {
                this.schema = "https";
            }
            if (Objects.isNull(this.hostAvailablerFactory)) {
                this.hostAvailablerFactory = new HostAvailablerFactory();
            }
            this.hostAvailabler = this.newHostAvailabler();
            if (Objects.isNull(this.callerConfig)) {
                this.callerConfig = HTTPCaller.getDefaultConfig();
            }
        }

        private synchronized void initGlobalHostAvailabler() throws BizException {
            if (Objects.nonNull(globalHostAvailabler)) {
                return;
            }
            globalHostAvailabler = this.newHostAvailabler();
        }

        private HostAvailabler newHostAvailabler() throws BizException {
            if (Utils.isNotEmptyList(this.hosts)) {
                return this.hostAvailablerFactory.newHostAvailabler(this.projectID, this.hosts, this.mainHost, true);
            }
            return this.hostAvailablerFactory.newHostAvailabler(this.projectID, this.region.getHosts(), this.mainHost, false);
        }

        private HTTPCaller newHTTPCaller() {
            if (this.useAirAuth) {
                return new HTTPCaller(this.projectID, this.tenantID, this.airAuthToken, this.hostAvailabler, this.callerConfig, this.schema, this.keepAlive);
            }
            String authRegion = this.region.getAuthRegion();
            Auth.Credential credential = new Auth.Credential(this.authAK, this.authSK, this.authService, authRegion);
            return new HTTPCaller(this.projectID, this.tenantID, credential, this.hostAvailabler, this.callerConfig, this.schema, this.keepAlive);
        }

        public Builder tenantID(String tenantID) {
            this.tenantID = tenantID;
            return this;
        }

        public Builder projectID(String projectID) {
            this.projectID = projectID;
            return this;
        }

        public Builder useAirAuth(boolean useAirAuth) {
            this.useAirAuth = useAirAuth;
            return this;
        }

        public Builder airAuthToken(String airAuthToken) {
            this.airAuthToken = airAuthToken;
            return this;
        }

        public Builder authAK(String authAK) {
            this.authAK = authAK;
            return this;
        }

        public Builder authSK(String authSK) {
            this.authSK = authSK;
            return this;
        }

        public Builder authService(String authService) {
            this.authService = authService;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder hosts(List<String> hosts) {
            this.hosts = hosts;
            return this;
        }

        public Builder mainHost(String mainHost) {
            this.mainHost = mainHost;
            return this;
        }

        public Builder region(IRegion region) {
            this.region = region;
            return this;
        }

        public Builder hostAvailablerFactory(HostAvailablerFactory hostAvailablerFactory) {
            this.hostAvailablerFactory = hostAvailablerFactory;
            return this;
        }

        public Builder keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder callerConfig(HTTPCaller.Config callerConfig) {
            this.callerConfig = callerConfig;
            return this;
        }

        public Builder hostAvailabler(HostAvailabler hostAvailabler) {
            this.hostAvailabler = hostAvailabler;
            return this;
        }

        public Builder metricsCfg(MetricsCollector.MetricsCfg metricsCfg) {
            this.metricsCfg = metricsCfg;
            return this;
        }

        @Deprecated
        public Builder callerClient(OkHttpClient callerClient) {
            this.callerClient = callerClient;
            return this;
        }
    }
}

