/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.core;

import com.byteplus.rec.core.AbstractHostAvailabler;
import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.Utils;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingHostAvailabler
extends AbstractHostAvailabler {
    private static final Logger log = LoggerFactory.getLogger(PingHostAvailabler.class);
    private static final int DEFAULT_WINDOW_SIZE = 60;
    private static final String DEFAULT_PING_SCHEMA = "http";
    private static final String DEFAULT_PING_URL_FORMAT = "%s://%s/predict/api/ping";
    private static final Duration DEFAULT_PING_TIMEOUT = Duration.ofMillis(300L);
    private static final Duration DEFAULT_PING_INTERVAL = Duration.ofSeconds(1L);
    private static final Duration DEFAULT_FETCH_HOST_INTERVAL = Duration.ofSeconds(10L);
    private final Config config;
    private final Map<String, Window> hostWindowMap = new HashMap<String, Window>();
    private final OkHttpClient httpCli;

    public PingHostAvailabler(List<String> hosts) throws BizException {
        this(hosts, new Config());
    }

    public PingHostAvailabler(List<String> hosts, Config config) throws BizException {
        super(hosts, false);
        this.config = this.fillDefaultConfig(config);
        this.httpCli = Utils.buildOkHTTPClient(this.config.pingTimeout);
        this.init(this.config.fetchHostInterval, this.config.pingInterval);
    }

    public PingHostAvailabler(String projectID, List<String> hosts) throws BizException {
        this(projectID, hosts, new Config());
    }

    public PingHostAvailabler(String projectID, List<String> hosts, Config config) throws BizException {
        super(projectID, hosts, false);
        this.config = this.fillDefaultConfig(config);
        this.httpCli = Utils.buildOkHTTPClient(this.config.pingTimeout);
        this.init(this.config.fetchHostInterval, this.config.pingInterval);
    }

    public PingHostAvailabler(String projectID, List<String> hosts, Config config, String mainHost, boolean skipFetchHosts) throws BizException {
        super(projectID, hosts, mainHost, skipFetchHosts, false);
        this.config = this.fillDefaultConfig(config);
        this.httpCli = Utils.buildOkHTTPClient(this.config.pingTimeout);
        this.init(this.config.fetchHostInterval, this.config.pingInterval);
    }

    private Config fillDefaultConfig(Config config) {
        if (Objects.isNull(config)) {
            config = new Config();
        }
        if (Objects.isNull((config = config.toBuilder().build()).pingURLFormat)) {
            config.pingURLFormat = DEFAULT_PING_URL_FORMAT;
        }
        if (Objects.isNull(config.pingTimeout) || config.pingTimeout.isZero()) {
            config.pingTimeout = PingHostAvailabler.DEFAULT_PING_TIMEOUT;
        }
        if (config.windowSize <= 0) {
            config.windowSize = 60;
        }
        if (Objects.isNull(config.pingInterval) || config.pingInterval.isZero()) {
            config.pingInterval = PingHostAvailabler.DEFAULT_PING_INTERVAL;
        }
        if (Objects.isNull(config.fetchHostInterval) || config.fetchHostInterval.isZero()) {
            config.fetchHostInterval = PingHostAvailabler.DEFAULT_FETCH_HOST_INTERVAL;
        }
        return config;
    }

    @Override
    protected List<AbstractHostAvailabler.HostAvailabilityScore> doScoreHosts(List<String> hosts) {
        log.debug("[ByteplusSDK] do score hosts:{}", (Object)hosts);
        if (hosts.size() == 1) {
            return Collections.singletonList(new AbstractHostAvailabler.HostAvailabilityScore(hosts.get(0), 0.0));
        }
        for (String host2 : hosts) {
            Window window = this.hostWindowMap.get(host2);
            if (Objects.isNull(window)) {
                window = new Window(this.config.windowSize);
                this.hostWindowMap.put(host2, window);
            }
            window.put(Utils.ping(this.projectID, this.httpCli, this.config.getPingURLFormat(), DEFAULT_PING_SCHEMA, host2));
        }
        return hosts.stream().map(host -> {
            double score = 1.0f - this.hostWindowMap.get(host).failureRate();
            return new AbstractHostAvailabler.HostAvailabilityScore((String)host, score);
        }).collect(Collectors.toList());
    }

    private static class Window {
        private final int size;
        private final boolean[] items;
        private int head;
        private int tail = 0;
        private float failureCount = 0.0f;

        private Window(int size) {
            this.size = size;
            this.head = size - 1;
            this.items = new boolean[size];
            Arrays.fill(this.items, true);
        }

        void put(boolean success) {
            if (!success) {
                this.failureCount += 1.0f;
            }
            this.head = (this.head + 1) % this.size;
            this.items[this.head] = success;
            this.tail = (this.tail + 1) % this.size;
            boolean removingItem = this.items[this.tail];
            if (!removingItem) {
                this.failureCount -= 1.0f;
            }
        }

        float failureRate() {
            return this.failureCount / (float)this.size;
        }
    }

    public static class Config {
        private String pingURLFormat;
        private Duration pingTimeout;
        private Duration pingInterval;
        private Duration fetchHostInterval;
        private int windowSize;

        public static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        public ConfigBuilder toBuilder() {
            return new ConfigBuilder().pingURLFormat(this.pingURLFormat).pingTimeout(this.pingTimeout).pingInterval(this.pingInterval).fetchHostInterval(this.fetchHostInterval).windowSize(this.windowSize);
        }

        public String getPingURLFormat() {
            return this.pingURLFormat;
        }

        public Duration getPingTimeout() {
            return this.pingTimeout;
        }

        public Duration getPingInterval() {
            return this.pingInterval;
        }

        public Duration getFetchHostInterval() {
            return this.fetchHostInterval;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public Config() {
        }

        public Config(String pingURLFormat, Duration pingTimeout, Duration pingInterval, Duration fetchHostInterval, int windowSize) {
            this.pingURLFormat = pingURLFormat;
            this.pingTimeout = pingTimeout;
            this.pingInterval = pingInterval;
            this.fetchHostInterval = fetchHostInterval;
            this.windowSize = windowSize;
        }

        public static class ConfigBuilder {
            private String pingURLFormat;
            private Duration pingTimeout;
            private Duration pingInterval;
            private Duration fetchHostInterval;
            private int windowSize;

            ConfigBuilder() {
            }

            public ConfigBuilder pingURLFormat(String pingURLFormat) {
                this.pingURLFormat = pingURLFormat;
                return this;
            }

            public ConfigBuilder pingTimeout(Duration pingTimeout) {
                this.pingTimeout = pingTimeout;
                return this;
            }

            public ConfigBuilder pingInterval(Duration pingInterval) {
                this.pingInterval = pingInterval;
                return this;
            }

            public ConfigBuilder fetchHostInterval(Duration fetchHostInterval) {
                this.fetchHostInterval = fetchHostInterval;
                return this;
            }

            public ConfigBuilder windowSize(int windowSize) {
                this.windowSize = windowSize;
                return this;
            }

            public Config build() {
                return new Config(this.pingURLFormat, this.pingTimeout, this.pingInterval, this.fetchHostInterval, this.windowSize);
            }

            public String toString() {
                return "PingHostAvailabler.Config.ConfigBuilder(pingURLFormat=" + this.pingURLFormat + ", pingTimeout=" + this.pingTimeout + ", pingInterval=" + this.pingInterval + ", fetchHostInterval=" + this.fetchHostInterval + ", windowSize=" + this.windowSize + ")";
            }
        }
    }
}

