/*
 * Decompiled with CFR 0.152.
 */
package com.byteplus.rec.core.metrics;

import com.byteplus.rec.core.BizException;
import com.byteplus.rec.core.HostAvailabler;
import com.byteplus.rec.core.metrics.Constant;
import com.byteplus.rec.core.metrics.MetricsOption;
import com.byteplus.rec.core.metrics.MetricsReporter;
import com.byteplus.rec.core.metrics.protocol.ByteplusRecSdkMetrics;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollector {
    private static final Logger log = LoggerFactory.getLogger(MetricsCollector.class);
    private static MetricsCfg metricsCfg;
    private static MetricsReporter metricsReporter;
    private static Queue<ByteplusRecSdkMetrics.Metric> metricsCollector;
    private static Queue<ByteplusRecSdkMetrics.MetricLog> metricsLogCollector;
    private static volatile boolean cleaningMetricsCollector;
    private static volatile boolean cleaningMetricsLogCollector;
    private static final AtomicBoolean initialed;
    private static ScheduledExecutorService reportExecutor;
    private static volatile HostAvailabler hostAvailabler;

    public static void Init(MetricsCfg metricsConfig, HostAvailabler hostAvailabler) {
        if (initialed.get()) {
            return;
        }
        metricsConfig = MetricsCollector.fillDefaultConfig(metricsConfig);
        MetricsCollector.doInit(metricsConfig, hostAvailabler);
    }

    private static MetricsCfg fillDefaultConfig(MetricsCfg metricsConfig) {
        if (Objects.isNull(metricsConfig)) {
            metricsConfig = new MetricsCfg();
        }
        if (Objects.isNull((metricsConfig = metricsConfig.toBuilder().build()).httpSchema) || metricsConfig.httpSchema.isEmpty()) {
            metricsConfig.httpSchema = "https";
        }
        if (Objects.isNull(metricsConfig.domain) || metricsConfig.domain.isEmpty()) {
            metricsConfig.domain = "rec-api-sg1.recplusapi.com";
        }
        if (Objects.isNull(metricsConfig.prefix) || metricsConfig.prefix.isEmpty()) {
            metricsConfig.prefix = "byteplus.rec.sdk";
        }
        if (Objects.isNull(metricsConfig.reportInterval) || metricsConfig.reportInterval.isZero()) {
            metricsConfig.reportInterval = Constant.DEFAULT_REPORT_INTERVAL;
        }
        if (Objects.isNull(metricsConfig.httpTimeout) || metricsConfig.httpTimeout.isZero()) {
            metricsConfig.httpTimeout = Constant.DEFAULT_HTTP_TIMEOUT;
        }
        return metricsConfig;
    }

    public static void Init(MetricsOption ... opts) {
        if (initialed.get()) {
            return;
        }
        MetricsCfg metricsConfig = new MetricsCfg();
        for (MetricsOption opt : opts) {
            opt.fill(metricsConfig);
        }
        MetricsCollector.doInit(metricsConfig, null);
    }

    private static synchronized void doInit(MetricsCfg metricsConfig, HostAvailabler hostAvailabler) {
        if (initialed.get()) {
            return;
        }
        metricsCfg = metricsConfig;
        MetricsCollector.hostAvailabler = hostAvailabler;
        metricsReporter = new MetricsReporter(metricsCfg);
        metricsCollector = new ConcurrentLinkedQueue<ByteplusRecSdkMetrics.Metric>();
        metricsLogCollector = new ConcurrentLinkedQueue<ByteplusRecSdkMetrics.MetricLog>();
        if (!MetricsCollector.isEnableMetrics() && !MetricsCollector.isEnableMetricsLog()) {
            initialed.set(true);
            return;
        }
        reportExecutor = Executors.newSingleThreadScheduledExecutor();
        reportExecutor.scheduleAtFixedRate(MetricsCollector::report, metricsCfg.reportInterval.toMillis(), metricsCfg.reportInterval.toMillis(), TimeUnit.MILLISECONDS);
        initialed.set(true);
    }

    public static boolean isInitialed() {
        return initialed.get();
    }

    public static boolean isEnableMetrics() {
        if (Objects.isNull(metricsCfg)) {
            return false;
        }
        return metricsCfg.isEnableMetrics();
    }

    public static boolean isEnableMetricsLog() {
        if (Objects.isNull(metricsCfg)) {
            return false;
        }
        return metricsCfg.isEnableMetricsLog();
    }

    public static void emitMetric(String type, String name, long value, String ... tagKvs) {
        if (!MetricsCollector.isEnableMetrics()) {
            return;
        }
        int tryTimes = 0;
        while (cleaningMetricsCollector) {
            try {
                if (tryTimes >= 5) {
                    return;
                }
                Thread.sleep(5L);
                ++tryTimes;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (metricsCollector.size() > 10000) {
            log.debug("[MetricsCollector]: The number of metrics exceeds the limit, the metrics write is rejected");
            return;
        }
        String metricName = name;
        if (metricsCfg.getPrefix().length() > 0) {
            metricName = metricsCfg.getPrefix() + "." + metricName;
        }
        ByteplusRecSdkMetrics.Metric metric = ByteplusRecSdkMetrics.Metric.newBuilder().setType(type).setName(metricName).setValue(value).setTimestamp(System.currentTimeMillis()).putAllTags(MetricsCollector.recoverTags(tagKvs)).build();
        metricsCollector.add(metric);
    }

    public static Map<String, String> recoverTags(String ... tagKvs) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (String tagKv : tagKvs) {
            String[] keyValue = tagKv.split(":", 2);
            if (keyValue.length < 2) continue;
            tags.put(keyValue[0], keyValue[1]);
        }
        return tags;
    }

    public static void emitLog(String logID, String message, String logLevel, Long timestamp) {
        if (!MetricsCollector.isEnableMetricsLog()) {
            return;
        }
        int tryTimes = 0;
        while (cleaningMetricsLogCollector) {
            try {
                if (tryTimes >= 5) {
                    return;
                }
                Thread.sleep(5L);
                ++tryTimes;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (metricsLogCollector.size() > 5000) {
            log.debug("[MetricsCollector]: The number of metrics logs exceeds the limit, the metrics log write is rejected");
            return;
        }
        ByteplusRecSdkMetrics.MetricLog metricLog = ByteplusRecSdkMetrics.MetricLog.newBuilder().setId(logID).setMessage(message).setLevel(logLevel).setTimestamp(timestamp).build();
        metricsLogCollector.add(metricLog);
    }

    private static void report() {
        if (MetricsCollector.isEnableMetrics()) {
            MetricsCollector.reportMetrics();
        }
        if (MetricsCollector.isEnableMetricsLog()) {
            MetricsCollector.reportMetricsLog();
        }
    }

    private static void reportMetrics() {
        ByteplusRecSdkMetrics.Metric metric;
        if (metricsCollector.size() == 0) {
            return;
        }
        ArrayList<ByteplusRecSdkMetrics.Metric> metrics = new ArrayList<ByteplusRecSdkMetrics.Metric>();
        cleaningMetricsCollector = true;
        while (!Objects.isNull(metric = metricsCollector.poll())) {
            metrics.add(metric);
        }
        cleaningMetricsCollector = false;
        MetricsCollector.doReportMetrics(metrics);
    }

    private static void doReportMetrics(List<ByteplusRecSdkMetrics.Metric> metrics) {
        String url = String.format("%s://%s/predict/api/monitor/metrics", metricsCfg.getHttpSchema(), MetricsCollector.getDomain("/monitor/metrics"));
        ByteplusRecSdkMetrics.MetricMessage metricMessage = ByteplusRecSdkMetrics.MetricMessage.newBuilder().addAllMetrics(metrics).build();
        try {
            metricsReporter.report(metricMessage, url);
        }
        catch (BizException e) {
            log.error("[BytePlusSDK][Metrics] report metrics exception, msg:{}, url:{}", (Object)e.getMessage(), (Object)url);
        }
    }

    private static String getDomain(String path) {
        if (Objects.nonNull(hostAvailabler)) {
            return hostAvailabler.getHost(path);
        }
        return metricsCfg.getDomain();
    }

    private static void reportMetricsLog() {
        ByteplusRecSdkMetrics.MetricLog metricLog;
        if (metricsLogCollector.size() == 0) {
            return;
        }
        ArrayList<ByteplusRecSdkMetrics.MetricLog> metricLogs = new ArrayList<ByteplusRecSdkMetrics.MetricLog>();
        cleaningMetricsLogCollector = true;
        while (!Objects.isNull(metricLog = metricsLogCollector.poll())) {
            metricLogs.add(metricLog);
        }
        cleaningMetricsLogCollector = false;
        MetricsCollector.doReportMetricsLogs(metricLogs);
    }

    private static void doReportMetricsLogs(List<ByteplusRecSdkMetrics.MetricLog> metricsLogs) {
        String url = String.format("%s://%s/predict/api/monitor/metrics/log", metricsCfg.getHttpSchema(), MetricsCollector.getDomain("/monitor/metrics/log"));
        ByteplusRecSdkMetrics.MetricLogMessage metricLogMessage = ByteplusRecSdkMetrics.MetricLogMessage.newBuilder().addAllMetricLogs(metricsLogs).build();
        try {
            metricsReporter.report(metricLogMessage, url);
        }
        catch (BizException e) {
            log.error("[BytePlusSDK][Metrics] report metrics log exception, msg:{}, url:{}", (Object)e.getMessage(), (Object)url);
        }
    }

    static {
        initialed = new AtomicBoolean(false);
    }

    public static class MetricsCfg {
        private boolean enableMetrics;
        private boolean enableMetricsLog;
        private String domain;
        private String prefix;
        private String httpSchema;
        private Duration reportInterval;
        private Duration httpTimeout;

        public MetricsCfg() {
            this.setEnableMetrics(false);
            this.setEnableMetricsLog(false);
            this.setDomain("rec-api-sg1.recplusapi.com");
            this.setPrefix("byteplus.rec.sdk");
            this.setHttpSchema("https");
            this.setReportInterval(Constant.DEFAULT_REPORT_INTERVAL);
            this.setHttpTimeout(Constant.DEFAULT_HTTP_TIMEOUT);
        }

        public static MetricsCfgBuilder builder() {
            return new MetricsCfgBuilder();
        }

        public MetricsCfgBuilder toBuilder() {
            return new MetricsCfgBuilder().enableMetrics(this.enableMetrics).enableMetricsLog(this.enableMetricsLog).domain(this.domain).prefix(this.prefix).httpSchema(this.httpSchema).reportInterval(this.reportInterval).httpTimeout(this.httpTimeout);
        }

        public boolean isEnableMetrics() {
            return this.enableMetrics;
        }

        public boolean isEnableMetricsLog() {
            return this.enableMetricsLog;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getHttpSchema() {
            return this.httpSchema;
        }

        public Duration getReportInterval() {
            return this.reportInterval;
        }

        public Duration getHttpTimeout() {
            return this.httpTimeout;
        }

        public void setEnableMetrics(boolean enableMetrics) {
            this.enableMetrics = enableMetrics;
        }

        public void setEnableMetricsLog(boolean enableMetricsLog) {
            this.enableMetricsLog = enableMetricsLog;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public void setHttpSchema(String httpSchema) {
            this.httpSchema = httpSchema;
        }

        public void setReportInterval(Duration reportInterval) {
            this.reportInterval = reportInterval;
        }

        public void setHttpTimeout(Duration httpTimeout) {
            this.httpTimeout = httpTimeout;
        }

        public MetricsCfg(boolean enableMetrics, boolean enableMetricsLog, String domain, String prefix, String httpSchema, Duration reportInterval, Duration httpTimeout) {
            this.enableMetrics = enableMetrics;
            this.enableMetricsLog = enableMetricsLog;
            this.domain = domain;
            this.prefix = prefix;
            this.httpSchema = httpSchema;
            this.reportInterval = reportInterval;
            this.httpTimeout = httpTimeout;
        }

        public static class MetricsCfgBuilder {
            private boolean enableMetrics;
            private boolean enableMetricsLog;
            private String domain;
            private String prefix;
            private String httpSchema;
            private Duration reportInterval;
            private Duration httpTimeout;

            MetricsCfgBuilder() {
            }

            public MetricsCfgBuilder enableMetrics(boolean enableMetrics) {
                this.enableMetrics = enableMetrics;
                return this;
            }

            public MetricsCfgBuilder enableMetricsLog(boolean enableMetricsLog) {
                this.enableMetricsLog = enableMetricsLog;
                return this;
            }

            public MetricsCfgBuilder domain(String domain) {
                this.domain = domain;
                return this;
            }

            public MetricsCfgBuilder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public MetricsCfgBuilder httpSchema(String httpSchema) {
                this.httpSchema = httpSchema;
                return this;
            }

            public MetricsCfgBuilder reportInterval(Duration reportInterval) {
                this.reportInterval = reportInterval;
                return this;
            }

            public MetricsCfgBuilder httpTimeout(Duration httpTimeout) {
                this.httpTimeout = httpTimeout;
                return this;
            }

            public MetricsCfg build() {
                return new MetricsCfg(this.enableMetrics, this.enableMetricsLog, this.domain, this.prefix, this.httpSchema, this.reportInterval, this.httpTimeout);
            }

            public String toString() {
                return "MetricsCollector.MetricsCfg.MetricsCfgBuilder(enableMetrics=" + this.enableMetrics + ", enableMetricsLog=" + this.enableMetricsLog + ", domain=" + this.domain + ", prefix=" + this.prefix + ", httpSchema=" + this.httpSchema + ", reportInterval=" + this.reportInterval + ", httpTimeout=" + this.httpTimeout + ")";
            }
        }
    }
}

